package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BasicLayout(
    moreInfo: Optional[zio.aws.connectcases.model.LayoutSections] =
      Optional.Absent,
    topPanel: Optional[zio.aws.connectcases.model.LayoutSections] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.BasicLayout = {
    import BasicLayout.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.BasicLayout
      .builder()
      .optionallyWith(moreInfo.map(value => value.buildAwsValue()))(_.moreInfo)
      .optionallyWith(topPanel.map(value => value.buildAwsValue()))(_.topPanel)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.BasicLayout.ReadOnly =
    zio.aws.connectcases.model.BasicLayout.wrap(buildAwsValue())
}
object BasicLayout {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.BasicLayout
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.BasicLayout =
      zio.aws.connectcases.model.BasicLayout(
        moreInfo.map(value => value.asEditable),
        topPanel.map(value => value.asEditable)
      )
    def moreInfo: Optional[zio.aws.connectcases.model.LayoutSections.ReadOnly]
    def topPanel: Optional[zio.aws.connectcases.model.LayoutSections.ReadOnly]
    def getMoreInfo: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.LayoutSections.ReadOnly
    ] = AwsError.unwrapOptionField("moreInfo", moreInfo)
    def getTopPanel: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.LayoutSections.ReadOnly
    ] = AwsError.unwrapOptionField("topPanel", topPanel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.BasicLayout
  ) extends zio.aws.connectcases.model.BasicLayout.ReadOnly {
    override val moreInfo
        : Optional[zio.aws.connectcases.model.LayoutSections.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moreInfo())
        .map(value => zio.aws.connectcases.model.LayoutSections.wrap(value))
    override val topPanel
        : Optional[zio.aws.connectcases.model.LayoutSections.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topPanel())
        .map(value => zio.aws.connectcases.model.LayoutSections.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.BasicLayout
  ): zio.aws.connectcases.model.BasicLayout.ReadOnly = new Wrapper(impl)
}
