package zio.aws.connectcases
import zio.aws.connectcases.model.GetCaseResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.connectcases.model.{
  GetCaseEventConfigurationRequest,
  GetCaseRequest,
  CreateRelatedItemRequest,
  CreateCaseRequest,
  ListCasesForContactRequest,
  BatchGetFieldRequest,
  BatchPutFieldOptionsRequest,
  ListTagsForResourceRequest,
  CreateFieldRequest,
  ListLayoutsRequest,
  CreateLayoutRequest,
  ListFieldOptionsRequest,
  DeleteDomainRequest,
  SearchCasesRequest,
  CreateDomainRequest,
  UpdateLayoutRequest,
  UntagResourceRequest,
  UpdateFieldRequest,
  GetDomainRequest,
  UpdateTemplateRequest,
  ListTemplatesRequest,
  SearchRelatedItemsRequest,
  GetTemplateRequest,
  ListFieldsRequest,
  UpdateCaseRequest,
  CreateTemplateRequest,
  PutCaseEventConfigurationRequest,
  ListDomainsRequest,
  TagResourceRequest,
  GetLayoutRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient
object ConnectCasesMock extends Mock[ConnectCases] {
  object BatchPutFieldOptions
      extends Effect[
        BatchPutFieldOptionsRequest,
        AwsError,
        zio.aws.connectcases.model.BatchPutFieldOptionsResponse.ReadOnly
      ]
  object UpdateLayout
      extends Effect[
        UpdateLayoutRequest,
        AwsError,
        zio.aws.connectcases.model.UpdateLayoutResponse.ReadOnly
      ]
  object ListLayouts
      extends Effect[
        ListLayoutsRequest,
        AwsError,
        zio.aws.connectcases.model.ListLayoutsResponse.ReadOnly
      ]
  object GetCaseEventConfiguration
      extends Effect[
        GetCaseEventConfigurationRequest,
        AwsError,
        zio.aws.connectcases.model.GetCaseEventConfigurationResponse.ReadOnly
      ]
  object UpdateTemplate
      extends Effect[
        UpdateTemplateRequest,
        AwsError,
        zio.aws.connectcases.model.UpdateTemplateResponse.ReadOnly
      ]
  object GetLayout
      extends Effect[
        GetLayoutRequest,
        AwsError,
        zio.aws.connectcases.model.GetLayoutResponse.ReadOnly
      ]
  object CreateRelatedItem
      extends Effect[
        CreateRelatedItemRequest,
        AwsError,
        zio.aws.connectcases.model.CreateRelatedItemResponse.ReadOnly
      ]
  object GetCase extends Effect[GetCaseRequest, AwsError, ReadOnly]
  object GetDomain
      extends Effect[
        GetDomainRequest,
        AwsError,
        zio.aws.connectcases.model.GetDomainResponse.ReadOnly
      ]
  object CreateTemplate
      extends Effect[
        CreateTemplateRequest,
        AwsError,
        zio.aws.connectcases.model.CreateTemplateResponse.ReadOnly
      ]
  object UpdateCase
      extends Effect[
        UpdateCaseRequest,
        AwsError,
        zio.aws.connectcases.model.UpdateCaseResponse.ReadOnly
      ]
  object ListDomains
      extends Effect[
        ListDomainsRequest,
        AwsError,
        zio.aws.connectcases.model.ListDomainsResponse.ReadOnly
      ]
  object UpdateField
      extends Effect[
        UpdateFieldRequest,
        AwsError,
        zio.aws.connectcases.model.UpdateFieldResponse.ReadOnly
      ]
  object ListTemplates
      extends Effect[
        ListTemplatesRequest,
        AwsError,
        zio.aws.connectcases.model.ListTemplatesResponse.ReadOnly
      ]
  object SearchCases
      extends Stream[
        SearchCasesRequest,
        AwsError,
        zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly
      ]
  object SearchCasesPaginated
      extends Effect[
        SearchCasesRequest,
        AwsError,
        zio.aws.connectcases.model.SearchCasesResponse.ReadOnly
      ]
  object ListFieldOptions
      extends Effect[
        ListFieldOptionsRequest,
        AwsError,
        zio.aws.connectcases.model.ListFieldOptionsResponse.ReadOnly
      ]
  object CreateDomain
      extends Effect[
        CreateDomainRequest,
        AwsError,
        zio.aws.connectcases.model.CreateDomainResponse.ReadOnly
      ]
  object SearchRelatedItems
      extends Stream[
        SearchRelatedItemsRequest,
        AwsError,
        zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly
      ]
  object SearchRelatedItemsPaginated
      extends Effect[
        SearchRelatedItemsRequest,
        AwsError,
        zio.aws.connectcases.model.SearchRelatedItemsResponse.ReadOnly
      ]
  object BatchGetField
      extends Effect[
        BatchGetFieldRequest,
        AwsError,
        zio.aws.connectcases.model.BatchGetFieldResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object PutCaseEventConfiguration
      extends Effect[
        PutCaseEventConfigurationRequest,
        AwsError,
        zio.aws.connectcases.model.PutCaseEventConfigurationResponse.ReadOnly
      ]
  object ListCasesForContact
      extends Effect[
        ListCasesForContactRequest,
        AwsError,
        zio.aws.connectcases.model.ListCasesForContactResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.connectcases.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object DeleteDomain
      extends Effect[
        DeleteDomainRequest,
        AwsError,
        zio.aws.connectcases.model.DeleteDomainResponse.ReadOnly
      ]
  object CreateCase
      extends Effect[
        CreateCaseRequest,
        AwsError,
        zio.aws.connectcases.model.CreateCaseResponse.ReadOnly
      ]
  object ListFields
      extends Effect[
        ListFieldsRequest,
        AwsError,
        zio.aws.connectcases.model.ListFieldsResponse.ReadOnly
      ]
  object GetTemplate
      extends Effect[
        GetTemplateRequest,
        AwsError,
        zio.aws.connectcases.model.GetTemplateResponse.ReadOnly
      ]
  object CreateField
      extends Effect[
        CreateFieldRequest,
        AwsError,
        zio.aws.connectcases.model.CreateFieldResponse.ReadOnly
      ]
  object CreateLayout
      extends Effect[
        CreateLayoutRequest,
        AwsError,
        zio.aws.connectcases.model.CreateLayoutResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ConnectCases] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ConnectCases] { rts =>
        zio.ZIO.succeed {
          new ConnectCases {
            val api: ConnectCasesAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ConnectCases = this
            def batchPutFieldOptions(request: BatchPutFieldOptionsRequest): IO[
              AwsError,
              zio.aws.connectcases.model.BatchPutFieldOptionsResponse.ReadOnly
            ] = proxy(BatchPutFieldOptions, request)
            def updateLayout(request: UpdateLayoutRequest): IO[
              AwsError,
              zio.aws.connectcases.model.UpdateLayoutResponse.ReadOnly
            ] = proxy(UpdateLayout, request)
            def listLayouts(request: ListLayoutsRequest): IO[
              AwsError,
              zio.aws.connectcases.model.ListLayoutsResponse.ReadOnly
            ] = proxy(ListLayouts, request)
            def getCaseEventConfiguration(
                request: GetCaseEventConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.connectcases.model.GetCaseEventConfigurationResponse.ReadOnly
            ] = proxy(GetCaseEventConfiguration, request)
            def updateTemplate(request: UpdateTemplateRequest): IO[
              AwsError,
              zio.aws.connectcases.model.UpdateTemplateResponse.ReadOnly
            ] = proxy(UpdateTemplate, request)
            def getLayout(request: GetLayoutRequest): IO[
              AwsError,
              zio.aws.connectcases.model.GetLayoutResponse.ReadOnly
            ] = proxy(GetLayout, request)
            def createRelatedItem(request: CreateRelatedItemRequest): IO[
              AwsError,
              zio.aws.connectcases.model.CreateRelatedItemResponse.ReadOnly
            ] = proxy(CreateRelatedItem, request)
            def getCase(request: GetCaseRequest): IO[AwsError, ReadOnly] =
              proxy(GetCase, request)
            def getDomain(request: GetDomainRequest): IO[
              AwsError,
              zio.aws.connectcases.model.GetDomainResponse.ReadOnly
            ] = proxy(GetDomain, request)
            def createTemplate(request: CreateTemplateRequest): IO[
              AwsError,
              zio.aws.connectcases.model.CreateTemplateResponse.ReadOnly
            ] = proxy(CreateTemplate, request)
            def updateCase(request: UpdateCaseRequest): IO[
              AwsError,
              zio.aws.connectcases.model.UpdateCaseResponse.ReadOnly
            ] = proxy(UpdateCase, request)
            def listDomains(request: ListDomainsRequest): IO[
              AwsError,
              zio.aws.connectcases.model.ListDomainsResponse.ReadOnly
            ] = proxy(ListDomains, request)
            def updateField(request: UpdateFieldRequest): IO[
              AwsError,
              zio.aws.connectcases.model.UpdateFieldResponse.ReadOnly
            ] = proxy(UpdateField, request)
            def listTemplates(request: ListTemplatesRequest): IO[
              AwsError,
              zio.aws.connectcases.model.ListTemplatesResponse.ReadOnly
            ] = proxy(ListTemplates, request)
            def searchCases(request: SearchCasesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchCases, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchCasesPaginated(request: SearchCasesRequest): IO[
              AwsError,
              zio.aws.connectcases.model.SearchCasesResponse.ReadOnly
            ] = proxy(SearchCasesPaginated, request)
            def listFieldOptions(request: ListFieldOptionsRequest): IO[
              AwsError,
              zio.aws.connectcases.model.ListFieldOptionsResponse.ReadOnly
            ] = proxy(ListFieldOptions, request)
            def createDomain(request: CreateDomainRequest): IO[
              AwsError,
              zio.aws.connectcases.model.CreateDomainResponse.ReadOnly
            ] = proxy(CreateDomain, request)
            def searchRelatedItems(request: SearchRelatedItemsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchRelatedItems, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchRelatedItemsPaginated(
                request: SearchRelatedItemsRequest
            ): IO[
              AwsError,
              zio.aws.connectcases.model.SearchRelatedItemsResponse.ReadOnly
            ] = proxy(SearchRelatedItemsPaginated, request)
            def batchGetField(request: BatchGetFieldRequest): IO[
              AwsError,
              zio.aws.connectcases.model.BatchGetFieldResponse.ReadOnly
            ] = proxy(BatchGetField, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def putCaseEventConfiguration(
                request: PutCaseEventConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.connectcases.model.PutCaseEventConfigurationResponse.ReadOnly
            ] = proxy(PutCaseEventConfiguration, request)
            def listCasesForContact(request: ListCasesForContactRequest): IO[
              AwsError,
              zio.aws.connectcases.model.ListCasesForContactResponse.ReadOnly
            ] = proxy(ListCasesForContact, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.connectcases.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def deleteDomain(request: DeleteDomainRequest): IO[
              AwsError,
              zio.aws.connectcases.model.DeleteDomainResponse.ReadOnly
            ] = proxy(DeleteDomain, request)
            def createCase(request: CreateCaseRequest): IO[
              AwsError,
              zio.aws.connectcases.model.CreateCaseResponse.ReadOnly
            ] = proxy(CreateCase, request)
            def listFields(request: ListFieldsRequest): IO[
              AwsError,
              zio.aws.connectcases.model.ListFieldsResponse.ReadOnly
            ] = proxy(ListFields, request)
            def getTemplate(request: GetTemplateRequest): IO[
              AwsError,
              zio.aws.connectcases.model.GetTemplateResponse.ReadOnly
            ] = proxy(GetTemplate, request)
            def createField(request: CreateFieldRequest): IO[
              AwsError,
              zio.aws.connectcases.model.CreateFieldResponse.ReadOnly
            ] = proxy(CreateField, request)
            def createLayout(request: CreateLayoutRequest): IO[
              AwsError,
              zio.aws.connectcases.model.CreateLayoutResponse.ReadOnly
            ] = proxy(CreateLayout, request)
          }
        }
      }
    }
  }
}
