package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.FieldId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RequiredField(fieldId: FieldId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.RequiredField = {
    import RequiredField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.RequiredField
      .builder()
      .fieldId(FieldId.unwrap(fieldId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.RequiredField.ReadOnly =
    zio.aws.connectcases.model.RequiredField.wrap(buildAwsValue())
}
object RequiredField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.RequiredField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.RequiredField =
      zio.aws.connectcases.model.RequiredField(fieldId)
    def fieldId: FieldId
    def getFieldId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(fieldId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.RequiredField
  ) extends zio.aws.connectcases.model.RequiredField.ReadOnly {
    override val fieldId: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.fieldId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.RequiredField
  ): zio.aws.connectcases.model.RequiredField.ReadOnly = new Wrapper(impl)
}
