package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.DomainId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutCaseEventConfigurationRequest(
    domainId: DomainId,
    eventBridge: zio.aws.connectcases.model.EventBridgeConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.PutCaseEventConfigurationRequest = {
    import PutCaseEventConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.PutCaseEventConfigurationRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .eventBridge(eventBridge.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.connectcases.model.PutCaseEventConfigurationRequest.ReadOnly =
    zio.aws.connectcases.model.PutCaseEventConfigurationRequest
      .wrap(buildAwsValue())
}
object PutCaseEventConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.PutCaseEventConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.connectcases.model.PutCaseEventConfigurationRequest =
      zio.aws.connectcases.model
        .PutCaseEventConfigurationRequest(domainId, eventBridge.asEditable)
    def domainId: DomainId
    def eventBridge
        : zio.aws.connectcases.model.EventBridgeConfiguration.ReadOnly
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getEventBridge: ZIO[
      Any,
      Nothing,
      zio.aws.connectcases.model.EventBridgeConfiguration.ReadOnly
    ] = ZIO.succeed(eventBridge)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.PutCaseEventConfigurationRequest
  ) extends zio.aws.connectcases.model.PutCaseEventConfigurationRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val eventBridge
        : zio.aws.connectcases.model.EventBridgeConfiguration.ReadOnly =
      zio.aws.connectcases.model.EventBridgeConfiguration
        .wrap(impl.eventBridge())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.PutCaseEventConfigurationRequest
  ): zio.aws.connectcases.model.PutCaseEventConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
