package zio.aws.connectcases.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcases.model.primitives.{NextToken, MaxResults, DomainId}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTemplatesRequest(
    domainId: DomainId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    status: Optional[Iterable[zio.aws.connectcases.model.TemplateStatus]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest = {
    import ListTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        status.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ListTemplatesRequest.ReadOnly =
    zio.aws.connectcases.model.ListTemplatesRequest.wrap(buildAwsValue())
}
object ListTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListTemplatesRequest =
      zio.aws.connectcases.model.ListTemplatesRequest(
        domainId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        status.map(value => value)
      )
    def domainId: DomainId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def status: Optional[List[zio.aws.connectcases.model.TemplateStatus]]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus
        : ZIO[Any, AwsError, List[zio.aws.connectcases.model.TemplateStatus]] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest
  ) extends zio.aws.connectcases.model.ListTemplatesRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.connectcases.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
    override val status
        : Optional[List[zio.aws.connectcases.model.TemplateStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.TemplateStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest
  ): zio.aws.connectcases.model.ListTemplatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
