package zio.aws.connectcases.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.connectcases.model.primitives.{
  NextToken,
  ListDomainsRequestMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDomainsRequest(
    maxResults: Optional[ListDomainsRequestMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListDomainsRequest = {
    import ListDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListDomainsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListDomainsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ListDomainsRequest.ReadOnly =
    zio.aws.connectcases.model.ListDomainsRequest.wrap(buildAwsValue())
}
object ListDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListDomainsRequest =
      zio.aws.connectcases.model.ListDomainsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListDomainsRequestMaxResultsInteger]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, ListDomainsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListDomainsRequest
  ) extends zio.aws.connectcases.model.ListDomainsRequest.ReadOnly {
    override val maxResults: Optional[ListDomainsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.connectcases.model.primitives
            .ListDomainsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListDomainsRequest
  ): zio.aws.connectcases.model.ListDomainsRequest.ReadOnly = new Wrapper(impl)
}
