package zio.aws.connectcases.model
import scala.jdk.CollectionConverters.*
sealed trait FieldType {
  def unwrap: software.amazon.awssdk.services.connectcases.model.FieldType
}
object FieldType {
  def wrap(
      value: software.amazon.awssdk.services.connectcases.model.FieldType
  ): zio.aws.connectcases.model.FieldType = value match {
    case software.amazon.awssdk.services.connectcases.model.FieldType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.connectcases.model.FieldType.TEXT =>
      val r = Text
      r
    case software.amazon.awssdk.services.connectcases.model.FieldType.NUMBER =>
      val r = Number
      r
    case software.amazon.awssdk.services.connectcases.model.FieldType.BOOLEAN =>
      val r = Boolean
      r
    case software.amazon.awssdk.services.connectcases.model.FieldType.DATE_TIME =>
      val r = DateTime
      r
    case software.amazon.awssdk.services.connectcases.model.FieldType.SINGLE_SELECT =>
      val r = SingleSelect
      r
    case software.amazon.awssdk.services.connectcases.model.FieldType.URL =>
      val r = Url
      r
  }
  case object unknownToSdkVersion extends zio.aws.connectcases.model.FieldType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.FieldType =
      software.amazon.awssdk.services.connectcases.model.FieldType.UNKNOWN_TO_SDK_VERSION
  }
  case object Text extends zio.aws.connectcases.model.FieldType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.FieldType =
      software.amazon.awssdk.services.connectcases.model.FieldType.TEXT
  }
  case object Number extends zio.aws.connectcases.model.FieldType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.FieldType =
      software.amazon.awssdk.services.connectcases.model.FieldType.NUMBER
  }
  case object Boolean extends zio.aws.connectcases.model.FieldType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.FieldType =
      software.amazon.awssdk.services.connectcases.model.FieldType.BOOLEAN
  }
  case object DateTime extends zio.aws.connectcases.model.FieldType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.FieldType =
      software.amazon.awssdk.services.connectcases.model.FieldType.DATE_TIME
  }
  case object SingleSelect extends zio.aws.connectcases.model.FieldType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.FieldType =
      software.amazon.awssdk.services.connectcases.model.FieldType.SINGLE_SELECT
  }
  case object Url extends zio.aws.connectcases.model.FieldType {
    override def unwrap
        : software.amazon.awssdk.services.connectcases.model.FieldType =
      software.amazon.awssdk.services.connectcases.model.FieldType.URL
  }
}
