package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.FieldId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FieldError(
    errorCode: String,
    id: FieldId,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldError = {
    import FieldError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldError
      .builder()
      .errorCode(errorCode: java.lang.String)
      .id(FieldId.unwrap(id): java.lang.String)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldError.ReadOnly =
    zio.aws.connectcases.model.FieldError.wrap(buildAwsValue())
}
object FieldError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldError =
      zio.aws.connectcases.model
        .FieldError(errorCode, id, message.map(value => value))
    def errorCode: String
    def id: FieldId
    def message: Optional[String]
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(id)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldError
  ) extends zio.aws.connectcases.model.FieldError.ReadOnly {
    override val errorCode: String = impl.errorCode(): String
    override val id: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.id())
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldError
  ): zio.aws.connectcases.model.FieldError.ReadOnly = new Wrapper(impl)
}
