package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventIncludedData(
    caseData: Optional[zio.aws.connectcases.model.CaseEventIncludedData] =
      Optional.Absent,
    relatedItemData: Optional[
      zio.aws.connectcases.model.RelatedItemEventIncludedData
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.EventIncludedData = {
    import EventIncludedData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.EventIncludedData
      .builder()
      .optionallyWith(caseData.map(value => value.buildAwsValue()))(_.caseData)
      .optionallyWith(relatedItemData.map(value => value.buildAwsValue()))(
        _.relatedItemData
      )
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.EventIncludedData.ReadOnly =
    zio.aws.connectcases.model.EventIncludedData.wrap(buildAwsValue())
}
object EventIncludedData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.EventIncludedData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.EventIncludedData =
      zio.aws.connectcases.model.EventIncludedData(
        caseData.map(value => value.asEditable),
        relatedItemData.map(value => value.asEditable)
      )
    def caseData
        : Optional[zio.aws.connectcases.model.CaseEventIncludedData.ReadOnly]
    def relatedItemData: Optional[
      zio.aws.connectcases.model.RelatedItemEventIncludedData.ReadOnly
    ]
    def getCaseData: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.CaseEventIncludedData.ReadOnly
    ] = AwsError.unwrapOptionField("caseData", caseData)
    def getRelatedItemData: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.RelatedItemEventIncludedData.ReadOnly
    ] = AwsError.unwrapOptionField("relatedItemData", relatedItemData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.EventIncludedData
  ) extends zio.aws.connectcases.model.EventIncludedData.ReadOnly {
    override val caseData
        : Optional[zio.aws.connectcases.model.CaseEventIncludedData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caseData())
        .map(value =>
          zio.aws.connectcases.model.CaseEventIncludedData.wrap(value)
        )
    override val relatedItemData: Optional[
      zio.aws.connectcases.model.RelatedItemEventIncludedData.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relatedItemData())
      .map(value =>
        zio.aws.connectcases.model.RelatedItemEventIncludedData.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.EventIncludedData
  ): zio.aws.connectcases.model.EventIncludedData.ReadOnly = new Wrapper(impl)
}
