package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{
  TemplateId,
  TemplateName,
  DomainId,
  TemplateDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTemplateRequest(
    description: Optional[TemplateDescription] = Optional.Absent,
    domainId: DomainId,
    layoutConfiguration: Optional[
      zio.aws.connectcases.model.LayoutConfiguration
    ] = Optional.Absent,
    name: Optional[TemplateName] = Optional.Absent,
    requiredFields: Optional[
      Iterable[zio.aws.connectcases.model.RequiredField]
    ] = Optional.Absent,
    status: Optional[zio.aws.connectcases.model.TemplateStatus] =
      Optional.Absent,
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.UpdateTemplateRequest = {
    import UpdateTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.UpdateTemplateRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(layoutConfiguration.map(value => value.buildAwsValue()))(
        _.layoutConfiguration
      )
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        requiredFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requiredFields)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.UpdateTemplateRequest.ReadOnly =
    zio.aws.connectcases.model.UpdateTemplateRequest.wrap(buildAwsValue())
}
object UpdateTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.UpdateTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.UpdateTemplateRequest =
      zio.aws.connectcases.model.UpdateTemplateRequest(
        description.map(value => value),
        domainId,
        layoutConfiguration.map(value => value.asEditable),
        name.map(value => value),
        requiredFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        templateId
      )
    def description: Optional[TemplateDescription]
    def domainId: DomainId
    def layoutConfiguration
        : Optional[zio.aws.connectcases.model.LayoutConfiguration.ReadOnly]
    def name: Optional[TemplateName]
    def requiredFields
        : Optional[List[zio.aws.connectcases.model.RequiredField.ReadOnly]]
    def status: Optional[zio.aws.connectcases.model.TemplateStatus]
    def templateId: TemplateId
    def getDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getLayoutConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.LayoutConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("layoutConfiguration", layoutConfiguration)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getRequiredFields: ZIO[Any, AwsError, List[
      zio.aws.connectcases.model.RequiredField.ReadOnly
    ]] = AwsError.unwrapOptionField("requiredFields", requiredFields)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.connectcases.model.TemplateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.UpdateTemplateRequest
  ) extends zio.aws.connectcases.model.UpdateTemplateRequest.ReadOnly {
    override val description: Optional[TemplateDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.connectcases.model.primitives.TemplateDescription(value)
        )
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val layoutConfiguration
        : Optional[zio.aws.connectcases.model.LayoutConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.layoutConfiguration())
        .map(value =>
          zio.aws.connectcases.model.LayoutConfiguration.wrap(value)
        )
    override val name: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.connectcases.model.primitives.TemplateName(value))
    override val requiredFields
        : Optional[List[zio.aws.connectcases.model.RequiredField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.connectcases.model.RequiredField.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.connectcases.model.TemplateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.connectcases.model.TemplateStatus.wrap(value))
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.UpdateTemplateRequest
  ): zio.aws.connectcases.model.UpdateTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
