package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(arn: Arn, tags: Map[String, String]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.TagResourceRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.TagResourceRequest.ReadOnly =
    zio.aws.connectcases.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.TagResourceRequest =
      zio.aws.connectcases.model.TagResourceRequest(arn, tags)
    def arn: Arn
    def tags: Map[String, String]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getTags: ZIO[Any, Nothing, Map[String, String]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.TagResourceRequest
  ) extends zio.aws.connectcases.model.TagResourceRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.connectcases.model.primitives.Arn(impl.arn())
    override val tags: Map[String, String] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.TagResourceRequest
  ): zio.aws.connectcases.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
