package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchCasesResponse(
    cases: Iterable[zio.aws.connectcases.model.SearchCasesResponseItem],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.SearchCasesResponse = {
    import SearchCasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.SearchCasesResponse
      .builder()
      .cases(cases.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.SearchCasesResponse.ReadOnly =
    zio.aws.connectcases.model.SearchCasesResponse.wrap(buildAwsValue())
}
object SearchCasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.SearchCasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.SearchCasesResponse =
      zio.aws.connectcases.model.SearchCasesResponse(
        cases.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def cases: List[zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly]
    def nextToken: Optional[NextToken]
    def getCases: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly
    ]] = ZIO.succeed(cases)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.SearchCasesResponse
  ) extends zio.aws.connectcases.model.SearchCasesResponse.ReadOnly {
    override val cases
        : List[zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly] =
      impl
        .cases()
        .asScala
        .map { item =>
          zio.aws.connectcases.model.SearchCasesResponseItem.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.SearchCasesResponse
  ): zio.aws.connectcases.model.SearchCasesResponse.ReadOnly = new Wrapper(impl)
}
