package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFieldsResponse(
    fields: Iterable[zio.aws.connectcases.model.FieldSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListFieldsResponse = {
    import ListFieldsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListFieldsResponse
      .builder()
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ListFieldsResponse.ReadOnly =
    zio.aws.connectcases.model.ListFieldsResponse.wrap(buildAwsValue())
}
object ListFieldsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListFieldsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListFieldsResponse =
      zio.aws.connectcases.model.ListFieldsResponse(
        fields.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def fields: List[zio.aws.connectcases.model.FieldSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldSummary.ReadOnly
    ]] = ZIO.succeed(fields)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListFieldsResponse
  ) extends zio.aws.connectcases.model.ListFieldsResponse.ReadOnly {
    override val fields
        : List[zio.aws.connectcases.model.FieldSummary.ReadOnly] = impl
      .fields()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.FieldSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListFieldsResponse
  ): zio.aws.connectcases.model.ListFieldsResponse.ReadOnly = new Wrapper(impl)
}
