package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.FieldId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FieldValue(
    id: FieldId,
    value: zio.aws.connectcases.model.FieldValueUnion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldValue = {
    import FieldValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldValue
      .builder()
      .id(FieldId.unwrap(id): java.lang.String)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldValue.ReadOnly =
    zio.aws.connectcases.model.FieldValue.wrap(buildAwsValue())
}
object FieldValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldValue =
      zio.aws.connectcases.model.FieldValue(id, value.asEditable)
    def id: FieldId
    def value: zio.aws.connectcases.model.FieldValueUnion.ReadOnly
    def getId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(id)
    def getValue: ZIO[
      Any,
      Nothing,
      zio.aws.connectcases.model.FieldValueUnion.ReadOnly
    ] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldValue
  ) extends zio.aws.connectcases.model.FieldValue.ReadOnly {
    override val id: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.id())
    override val value: zio.aws.connectcases.model.FieldValueUnion.ReadOnly =
      zio.aws.connectcases.model.FieldValueUnion.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldValue
  ): zio.aws.connectcases.model.FieldValue.ReadOnly = new Wrapper(impl)
}
