package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.FieldGroupNameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FieldGroup(
    fields: Iterable[zio.aws.connectcases.model.FieldItem],
    name: Optional[FieldGroupNameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.FieldGroup = {
    import FieldGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.FieldGroup
      .builder()
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        name.map(value => FieldGroupNameString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.FieldGroup.ReadOnly =
    zio.aws.connectcases.model.FieldGroup.wrap(buildAwsValue())
}
object FieldGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.FieldGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.FieldGroup =
      zio.aws.connectcases.model.FieldGroup(
        fields.map { item =>
          item.asEditable
        },
        name.map(value => value)
      )
    def fields: List[zio.aws.connectcases.model.FieldItem.ReadOnly]
    def name: Optional[FieldGroupNameString]
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldItem.ReadOnly
    ]] = ZIO.succeed(fields)
    def getName: ZIO[Any, AwsError, FieldGroupNameString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.FieldGroup
  ) extends zio.aws.connectcases.model.FieldGroup.ReadOnly {
    override val fields: List[zio.aws.connectcases.model.FieldItem.ReadOnly] =
      impl
        .fields()
        .asScala
        .map { item =>
          zio.aws.connectcases.model.FieldItem.wrap(item)
        }
        .toList
    override val name: Optional[FieldGroupNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.connectcases.model.primitives.FieldGroupNameString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.FieldGroup
  ): zio.aws.connectcases.model.FieldGroup.ReadOnly = new Wrapper(impl)
}
