package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{DomainId, CaseId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateCaseRequest(
    caseId: CaseId,
    domainId: DomainId,
    fields: Iterable[zio.aws.connectcases.model.FieldValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.UpdateCaseRequest = {
    import UpdateCaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.UpdateCaseRequest
      .builder()
      .caseId(CaseId.unwrap(caseId): java.lang.String)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.UpdateCaseRequest.ReadOnly =
    zio.aws.connectcases.model.UpdateCaseRequest.wrap(buildAwsValue())
}
object UpdateCaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.UpdateCaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.UpdateCaseRequest =
      zio.aws.connectcases.model.UpdateCaseRequest(
        caseId,
        domainId,
        fields.map { item =>
          item.asEditable
        }
      )
    def caseId: CaseId
    def domainId: DomainId
    def fields: List[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def getCaseId: ZIO[Any, Nothing, CaseId] = ZIO.succeed(caseId)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldValue.ReadOnly
    ]] = ZIO.succeed(fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.UpdateCaseRequest
  ) extends zio.aws.connectcases.model.UpdateCaseRequest.ReadOnly {
    override val caseId: CaseId =
      zio.aws.connectcases.model.primitives.CaseId(impl.caseId())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val fields: List[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      impl
        .fields()
        .asScala
        .map { item =>
          zio.aws.connectcases.model.FieldValue.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.UpdateCaseRequest
  ): zio.aws.connectcases.model.UpdateCaseRequest.ReadOnly = new Wrapper(impl)
}
