package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Section(
    fieldGroup: Optional[zio.aws.connectcases.model.FieldGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.Section = {
    import Section.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.Section
      .builder()
      .optionallyWith(fieldGroup.map(value => value.buildAwsValue()))(
        _.fieldGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.Section.ReadOnly =
    zio.aws.connectcases.model.Section.wrap(buildAwsValue())
}
object Section {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.Section
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.Section =
      zio.aws.connectcases.model
        .Section(fieldGroup.map(value => value.asEditable))
    def fieldGroup: Optional[zio.aws.connectcases.model.FieldGroup.ReadOnly]
    def getFieldGroup
        : ZIO[Any, AwsError, zio.aws.connectcases.model.FieldGroup.ReadOnly] =
      AwsError.unwrapOptionField("fieldGroup", fieldGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.Section
  ) extends zio.aws.connectcases.model.Section.ReadOnly {
    override val fieldGroup
        : Optional[zio.aws.connectcases.model.FieldGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fieldGroup())
        .map(value => zio.aws.connectcases.model.FieldGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.Section
  ): zio.aws.connectcases.model.Section.ReadOnly = new Wrapper(impl)
}
