package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFieldOptionsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    options: Iterable[zio.aws.connectcases.model.FieldOption]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse = {
    import ListFieldOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .options(options.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.ListFieldOptionsResponse.ReadOnly =
    zio.aws.connectcases.model.ListFieldOptionsResponse.wrap(buildAwsValue())
}
object ListFieldOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.ListFieldOptionsResponse =
      zio.aws.connectcases.model.ListFieldOptionsResponse(
        nextToken.map(value => value),
        options.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def options: List[zio.aws.connectcases.model.FieldOption.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOptions: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldOption.ReadOnly
    ]] = ZIO.succeed(options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse
  ) extends zio.aws.connectcases.model.ListFieldOptionsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.connectcases.model.primitives.NextToken(value))
    override val options
        : List[zio.aws.connectcases.model.FieldOption.ReadOnly] = impl
      .options()
      .asScala
      .map { item =>
        zio.aws.connectcases.model.FieldOption.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse
  ): zio.aws.connectcases.model.ListFieldOptionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
