package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{TemplateId, CaseId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CaseSummary(caseId: CaseId, templateId: TemplateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CaseSummary = {
    import CaseSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CaseSummary
      .builder()
      .caseId(CaseId.unwrap(caseId): java.lang.String)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CaseSummary.ReadOnly =
    zio.aws.connectcases.model.CaseSummary.wrap(buildAwsValue())
}
object CaseSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CaseSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CaseSummary =
      zio.aws.connectcases.model.CaseSummary(caseId, templateId)
    def caseId: CaseId
    def templateId: TemplateId
    def getCaseId: ZIO[Any, Nothing, CaseId] = ZIO.succeed(caseId)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CaseSummary
  ) extends zio.aws.connectcases.model.CaseSummary.ReadOnly {
    override val caseId: CaseId =
      zio.aws.connectcases.model.primitives.CaseId(impl.caseId())
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CaseSummary
  ): zio.aws.connectcases.model.CaseSummary.ReadOnly = new Wrapper(impl)
}
