package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.FieldId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Sort(
    fieldId: FieldId,
    sortOrder: zio.aws.connectcases.model.Order
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.Sort = {
    import Sort.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.Sort
      .builder()
      .fieldId(FieldId.unwrap(fieldId): java.lang.String)
      .sortOrder(sortOrder.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.Sort.ReadOnly =
    zio.aws.connectcases.model.Sort.wrap(buildAwsValue())
}
object Sort {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.connectcases.model.Sort] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.Sort =
      zio.aws.connectcases.model.Sort(fieldId, sortOrder)
    def fieldId: FieldId
    def sortOrder: zio.aws.connectcases.model.Order
    def getFieldId: ZIO[Any, Nothing, FieldId] = ZIO.succeed(fieldId)
    def getSortOrder: ZIO[Any, Nothing, zio.aws.connectcases.model.Order] =
      ZIO.succeed(sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.Sort
  ) extends zio.aws.connectcases.model.Sort.ReadOnly {
    override val fieldId: FieldId =
      zio.aws.connectcases.model.primitives.FieldId(impl.fieldId())
    override val sortOrder: zio.aws.connectcases.model.Order =
      zio.aws.connectcases.model.Order.wrap(impl.sortOrder())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.Sort
  ): zio.aws.connectcases.model.Sort.ReadOnly = new Wrapper(impl)
}
