package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{TemplateId, CaseId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SearchCasesResponseItem(
    caseId: CaseId,
    fields: Iterable[zio.aws.connectcases.model.FieldValue],
    tags: Optional[Map[String, String]] = Optional.Absent,
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem = {
    import SearchCasesResponseItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem
      .builder()
      .caseId(CaseId.unwrap(caseId): java.lang.String)
      .fields(fields.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly =
    zio.aws.connectcases.model.SearchCasesResponseItem.wrap(buildAwsValue())
}
object SearchCasesResponseItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.SearchCasesResponseItem =
      zio.aws.connectcases.model.SearchCasesResponseItem(
        caseId,
        fields.map { item =>
          item.asEditable
        },
        tags.map(value => value),
        templateId
      )
    def caseId: CaseId
    def fields: List[zio.aws.connectcases.model.FieldValue.ReadOnly]
    def tags: Optional[Map[String, String]]
    def templateId: TemplateId
    def getCaseId: ZIO[Any, Nothing, CaseId] = ZIO.succeed(caseId)
    def getFields: ZIO[Any, Nothing, List[
      zio.aws.connectcases.model.FieldValue.ReadOnly
    ]] = ZIO.succeed(fields)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem
  ) extends zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly {
    override val caseId: CaseId =
      zio.aws.connectcases.model.primitives.CaseId(impl.caseId())
    override val fields: List[zio.aws.connectcases.model.FieldValue.ReadOnly] =
      impl
        .fields()
        .asScala
        .map { item =>
          zio.aws.connectcases.model.FieldValue.wrap(item)
        }
        .toList
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val templateId: TemplateId =
      zio.aws.connectcases.model.primitives.TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem
  ): zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly = new Wrapper(
    impl
  )
}
