package zio.aws.connectcases.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RelatedItemContent(
    comment: Optional[zio.aws.connectcases.model.CommentContent] =
      Optional.Absent,
    contact: Optional[zio.aws.connectcases.model.ContactContent] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.RelatedItemContent = {
    import RelatedItemContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.RelatedItemContent
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .optionallyWith(contact.map(value => value.buildAwsValue()))(_.contact)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.RelatedItemContent.ReadOnly =
    zio.aws.connectcases.model.RelatedItemContent.wrap(buildAwsValue())
}
object RelatedItemContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.RelatedItemContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.RelatedItemContent =
      zio.aws.connectcases.model.RelatedItemContent(
        comment.map(value => value.asEditable),
        contact.map(value => value.asEditable)
      )
    def comment: Optional[zio.aws.connectcases.model.CommentContent.ReadOnly]
    def contact: Optional[zio.aws.connectcases.model.ContactContent.ReadOnly]
    def getComment: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.CommentContent.ReadOnly
    ] = AwsError.unwrapOptionField("comment", comment)
    def getContact: ZIO[
      Any,
      AwsError,
      zio.aws.connectcases.model.ContactContent.ReadOnly
    ] = AwsError.unwrapOptionField("contact", contact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.RelatedItemContent
  ) extends zio.aws.connectcases.model.RelatedItemContent.ReadOnly {
    override val comment
        : Optional[zio.aws.connectcases.model.CommentContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.connectcases.model.CommentContent.wrap(value))
    override val contact
        : Optional[zio.aws.connectcases.model.ContactContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contact())
        .map(value => zio.aws.connectcases.model.ContactContent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.RelatedItemContent
  ): zio.aws.connectcases.model.RelatedItemContent.ReadOnly = new Wrapper(impl)
}
