package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.LayoutId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LayoutConfiguration(
    defaultLayout: Optional[LayoutId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.LayoutConfiguration = {
    import LayoutConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.LayoutConfiguration
      .builder()
      .optionallyWith(
        defaultLayout.map(value => LayoutId.unwrap(value): java.lang.String)
      )(_.defaultLayout)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.LayoutConfiguration.ReadOnly =
    zio.aws.connectcases.model.LayoutConfiguration.wrap(buildAwsValue())
}
object LayoutConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.LayoutConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.LayoutConfiguration =
      zio.aws.connectcases.model
        .LayoutConfiguration(defaultLayout.map(value => value))
    def defaultLayout: Optional[LayoutId]
    def getDefaultLayout: ZIO[Any, AwsError, LayoutId] =
      AwsError.unwrapOptionField("defaultLayout", defaultLayout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.LayoutConfiguration
  ) extends zio.aws.connectcases.model.LayoutConfiguration.ReadOnly {
    override val defaultLayout: Optional[LayoutId] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultLayout())
      .map(value => zio.aws.connectcases.model.primitives.LayoutId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.LayoutConfiguration
  ): zio.aws.connectcases.model.LayoutConfiguration.ReadOnly = new Wrapper(impl)
}
