package zio.aws.connectcases.model
import zio.aws.connectcases.model.primitives.{LayoutName, DomainId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateLayoutRequest(
    content: zio.aws.connectcases.model.LayoutContent,
    domainId: DomainId,
    name: LayoutName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.connectcases.model.CreateLayoutRequest = {
    import CreateLayoutRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.connectcases.model.CreateLayoutRequest
      .builder()
      .content(content.buildAwsValue())
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .name(LayoutName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.connectcases.model.CreateLayoutRequest.ReadOnly =
    zio.aws.connectcases.model.CreateLayoutRequest.wrap(buildAwsValue())
}
object CreateLayoutRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.connectcases.model.CreateLayoutRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.connectcases.model.CreateLayoutRequest =
      zio.aws.connectcases.model
        .CreateLayoutRequest(content.asEditable, domainId, name)
    def content: zio.aws.connectcases.model.LayoutContent.ReadOnly
    def domainId: DomainId
    def name: LayoutName
    def getContent
        : ZIO[Any, Nothing, zio.aws.connectcases.model.LayoutContent.ReadOnly] =
      ZIO.succeed(content)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getName: ZIO[Any, Nothing, LayoutName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.connectcases.model.CreateLayoutRequest
  ) extends zio.aws.connectcases.model.CreateLayoutRequest.ReadOnly {
    override val content: zio.aws.connectcases.model.LayoutContent.ReadOnly =
      zio.aws.connectcases.model.LayoutContent.wrap(impl.content())
    override val domainId: DomainId =
      zio.aws.connectcases.model.primitives.DomainId(impl.domainId())
    override val name: LayoutName =
      zio.aws.connectcases.model.primitives.LayoutName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.connectcases.model.CreateLayoutRequest
  ): zio.aws.connectcases.model.CreateLayoutRequest.ReadOnly = new Wrapper(impl)
}
