package zio.aws.connectcases
import zio.aws.connectcases.model.GetCaseResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.connectcases.paginators.{
  SearchRelatedItemsPublisher,
  SearchCasesPublisher
}
import software.amazon.awssdk.services.connectcases.model.{
  UpdateLayoutResponse,
  GetCaseEventConfigurationRequest,
  GetDomainResponse,
  ListFieldOptionsResponse,
  BatchPutFieldOptionsResponse,
  GetCaseRequest,
  ListDomainsResponse,
  CreateDomainResponse,
  CreateRelatedItemRequest,
  CreateCaseRequest,
  ListCasesForContactRequest,
  ListTemplatesResponse,
  SearchRelatedItemsResponseItem,
  PutCaseEventConfigurationResponse,
  BatchGetFieldRequest,
  BatchPutFieldOptionsRequest,
  GetTemplateResponse,
  ListLayoutsResponse,
  GetCaseEventConfigurationResponse,
  ListTagsForResourceRequest,
  CreateRelatedItemResponse,
  CreateFieldRequest,
  CreateTemplateResponse,
  SearchRelatedItemsResponse,
  ListLayoutsRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateLayoutRequest,
  ListFieldOptionsRequest,
  UpdateTemplateResponse,
  UpdateFieldResponse,
  SearchCasesRequest,
  BatchGetFieldResponse,
  CreateCaseResponse,
  CreateDomainRequest,
  UpdateLayoutRequest,
  SearchCasesResponseItem,
  UntagResourceRequest,
  GetCaseResponse,
  UpdateFieldRequest,
  GetDomainRequest,
  UpdateTemplateRequest,
  ListFieldsResponse,
  ListTemplatesRequest,
  SearchRelatedItemsRequest,
  GetTemplateRequest,
  ListFieldsRequest,
  CreateLayoutResponse,
  TagResourceResponse,
  ListCasesForContactResponse,
  UpdateCaseResponse,
  UpdateCaseRequest,
  SearchCasesResponse,
  CreateTemplateRequest,
  PutCaseEventConfigurationRequest,
  ListDomainsRequest,
  TagResourceRequest,
  GetLayoutResponse,
  GetLayoutRequest,
  CreateFieldResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.connectcases.{
  ConnectCasesAsyncClientBuilder,
  ConnectCasesAsyncClient
}
import scala.jdk.CollectionConverters.*
trait ConnectCases extends AspectSupport[ConnectCases] {
  val api: ConnectCasesAsyncClient
  def batchPutFieldOptions(
      request: zio.aws.connectcases.model.BatchPutFieldOptionsRequest
  ): IO[
    AwsError,
    zio.aws.connectcases.model.BatchPutFieldOptionsResponse.ReadOnly
  ]
  def updateLayout(
      request: zio.aws.connectcases.model.UpdateLayoutRequest
  ): IO[AwsError, zio.aws.connectcases.model.UpdateLayoutResponse.ReadOnly]
  def listLayouts(
      request: zio.aws.connectcases.model.ListLayoutsRequest
  ): IO[AwsError, zio.aws.connectcases.model.ListLayoutsResponse.ReadOnly]
  def getCaseEventConfiguration(
      request: zio.aws.connectcases.model.GetCaseEventConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.connectcases.model.GetCaseEventConfigurationResponse.ReadOnly
  ]
  def updateTemplate(
      request: zio.aws.connectcases.model.UpdateTemplateRequest
  ): IO[AwsError, zio.aws.connectcases.model.UpdateTemplateResponse.ReadOnly]
  def getLayout(
      request: zio.aws.connectcases.model.GetLayoutRequest
  ): IO[AwsError, zio.aws.connectcases.model.GetLayoutResponse.ReadOnly]
  def createRelatedItem(
      request: zio.aws.connectcases.model.CreateRelatedItemRequest
  ): IO[AwsError, zio.aws.connectcases.model.CreateRelatedItemResponse.ReadOnly]
  def getCase(
      request: zio.aws.connectcases.model.GetCaseRequest
  ): IO[AwsError, ReadOnly]
  def getDomain(
      request: zio.aws.connectcases.model.GetDomainRequest
  ): IO[AwsError, zio.aws.connectcases.model.GetDomainResponse.ReadOnly]
  def createTemplate(
      request: zio.aws.connectcases.model.CreateTemplateRequest
  ): IO[AwsError, zio.aws.connectcases.model.CreateTemplateResponse.ReadOnly]
  def updateCase(
      request: zio.aws.connectcases.model.UpdateCaseRequest
  ): IO[AwsError, zio.aws.connectcases.model.UpdateCaseResponse.ReadOnly]
  def listDomains(
      request: zio.aws.connectcases.model.ListDomainsRequest
  ): IO[AwsError, zio.aws.connectcases.model.ListDomainsResponse.ReadOnly]
  def updateField(
      request: zio.aws.connectcases.model.UpdateFieldRequest
  ): IO[AwsError, zio.aws.connectcases.model.UpdateFieldResponse.ReadOnly]
  def listTemplates(
      request: zio.aws.connectcases.model.ListTemplatesRequest
  ): IO[AwsError, zio.aws.connectcases.model.ListTemplatesResponse.ReadOnly]
  def searchCases(
      request: zio.aws.connectcases.model.SearchCasesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly
  ]
  def searchCasesPaginated(
      request: zio.aws.connectcases.model.SearchCasesRequest
  ): IO[AwsError, zio.aws.connectcases.model.SearchCasesResponse.ReadOnly]
  def listFieldOptions(
      request: zio.aws.connectcases.model.ListFieldOptionsRequest
  ): IO[AwsError, zio.aws.connectcases.model.ListFieldOptionsResponse.ReadOnly]
  def createDomain(
      request: zio.aws.connectcases.model.CreateDomainRequest
  ): IO[AwsError, zio.aws.connectcases.model.CreateDomainResponse.ReadOnly]
  def searchRelatedItems(
      request: zio.aws.connectcases.model.SearchRelatedItemsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly
  ]
  def searchRelatedItemsPaginated(
      request: zio.aws.connectcases.model.SearchRelatedItemsRequest
  ): IO[
    AwsError,
    zio.aws.connectcases.model.SearchRelatedItemsResponse.ReadOnly
  ]
  def batchGetField(
      request: zio.aws.connectcases.model.BatchGetFieldRequest
  ): IO[AwsError, zio.aws.connectcases.model.BatchGetFieldResponse.ReadOnly]
  def untagResource(
      request: zio.aws.connectcases.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def putCaseEventConfiguration(
      request: zio.aws.connectcases.model.PutCaseEventConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.connectcases.model.PutCaseEventConfigurationResponse.ReadOnly
  ]
  def listCasesForContact(
      request: zio.aws.connectcases.model.ListCasesForContactRequest
  ): IO[
    AwsError,
    zio.aws.connectcases.model.ListCasesForContactResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.connectcases.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.connectcases.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.connectcases.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def createCase(
      request: zio.aws.connectcases.model.CreateCaseRequest
  ): IO[AwsError, zio.aws.connectcases.model.CreateCaseResponse.ReadOnly]
  def listFields(
      request: zio.aws.connectcases.model.ListFieldsRequest
  ): IO[AwsError, zio.aws.connectcases.model.ListFieldsResponse.ReadOnly]
  def getTemplate(
      request: zio.aws.connectcases.model.GetTemplateRequest
  ): IO[AwsError, zio.aws.connectcases.model.GetTemplateResponse.ReadOnly]
  def createField(
      request: zio.aws.connectcases.model.CreateFieldRequest
  ): IO[AwsError, zio.aws.connectcases.model.CreateFieldResponse.ReadOnly]
  def createLayout(
      request: zio.aws.connectcases.model.CreateLayoutRequest
  ): IO[AwsError, zio.aws.connectcases.model.CreateLayoutResponse.ReadOnly]
}
object ConnectCases {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ConnectCases] = customized(
    identity
  )
  def customized(
      customization: ConnectCasesAsyncClientBuilder => ConnectCasesAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ConnectCases] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ConnectCasesAsyncClientBuilder => ConnectCasesAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ConnectCases] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ConnectCasesAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ConnectCasesAsyncClient, ConnectCasesAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ConnectCasesAsyncClient,
      ConnectCasesAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ConnectCasesImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ConnectCasesImpl[R](
      override val api: ConnectCasesAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ConnectCases
      with AwsServiceBase[R] {
    override val serviceName: String = "ConnectCases"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ConnectCasesImpl[R1] = new ConnectCasesImpl(api, newAspect, r)
    def batchPutFieldOptions(
        request: zio.aws.connectcases.model.BatchPutFieldOptionsRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.BatchPutFieldOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchPutFieldOptionsRequest,
      BatchPutFieldOptionsResponse
    ]("batchPutFieldOptions", api.batchPutFieldOptions)(request.buildAwsValue())
      .map(zio.aws.connectcases.model.BatchPutFieldOptionsResponse.wrap)
      .provideEnvironment(r)
    def updateLayout(
        request: zio.aws.connectcases.model.UpdateLayoutRequest
    ): IO[AwsError, zio.aws.connectcases.model.UpdateLayoutResponse.ReadOnly] =
      asyncRequestResponse[UpdateLayoutRequest, UpdateLayoutResponse](
        "updateLayout",
        api.updateLayout
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.UpdateLayoutResponse.wrap)
        .provideEnvironment(r)
    def listLayouts(
        request: zio.aws.connectcases.model.ListLayoutsRequest
    ): IO[AwsError, zio.aws.connectcases.model.ListLayoutsResponse.ReadOnly] =
      asyncRequestResponse[ListLayoutsRequest, ListLayoutsResponse](
        "listLayouts",
        api.listLayouts
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.ListLayoutsResponse.wrap)
        .provideEnvironment(r)
    def getCaseEventConfiguration(
        request: zio.aws.connectcases.model.GetCaseEventConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.GetCaseEventConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCaseEventConfigurationRequest,
      GetCaseEventConfigurationResponse
    ]("getCaseEventConfiguration", api.getCaseEventConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.connectcases.model.GetCaseEventConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateTemplate(
        request: zio.aws.connectcases.model.UpdateTemplateRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.UpdateTemplateResponse.ReadOnly
    ] = asyncRequestResponse[UpdateTemplateRequest, UpdateTemplateResponse](
      "updateTemplate",
      api.updateTemplate
    )(request.buildAwsValue())
      .map(zio.aws.connectcases.model.UpdateTemplateResponse.wrap)
      .provideEnvironment(r)
    def getLayout(
        request: zio.aws.connectcases.model.GetLayoutRequest
    ): IO[AwsError, zio.aws.connectcases.model.GetLayoutResponse.ReadOnly] =
      asyncRequestResponse[GetLayoutRequest, GetLayoutResponse](
        "getLayout",
        api.getLayout
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.GetLayoutResponse.wrap)
        .provideEnvironment(r)
    def createRelatedItem(
        request: zio.aws.connectcases.model.CreateRelatedItemRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.CreateRelatedItemResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateRelatedItemRequest, CreateRelatedItemResponse](
        "createRelatedItem",
        api.createRelatedItem
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.CreateRelatedItemResponse.wrap)
        .provideEnvironment(r)
    def getCase(
        request: zio.aws.connectcases.model.GetCaseRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[GetCaseRequest, GetCaseResponse](
        "getCase",
        api.getCase
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.GetCaseResponse.wrap)
        .provideEnvironment(r)
    def getDomain(
        request: zio.aws.connectcases.model.GetDomainRequest
    ): IO[AwsError, zio.aws.connectcases.model.GetDomainResponse.ReadOnly] =
      asyncRequestResponse[GetDomainRequest, GetDomainResponse](
        "getDomain",
        api.getDomain
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.GetDomainResponse.wrap)
        .provideEnvironment(r)
    def createTemplate(
        request: zio.aws.connectcases.model.CreateTemplateRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.CreateTemplateResponse.ReadOnly
    ] = asyncRequestResponse[CreateTemplateRequest, CreateTemplateResponse](
      "createTemplate",
      api.createTemplate
    )(request.buildAwsValue())
      .map(zio.aws.connectcases.model.CreateTemplateResponse.wrap)
      .provideEnvironment(r)
    def updateCase(
        request: zio.aws.connectcases.model.UpdateCaseRequest
    ): IO[AwsError, zio.aws.connectcases.model.UpdateCaseResponse.ReadOnly] =
      asyncRequestResponse[UpdateCaseRequest, UpdateCaseResponse](
        "updateCase",
        api.updateCase
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.UpdateCaseResponse.wrap)
        .provideEnvironment(r)
    def listDomains(
        request: zio.aws.connectcases.model.ListDomainsRequest
    ): IO[AwsError, zio.aws.connectcases.model.ListDomainsResponse.ReadOnly] =
      asyncRequestResponse[ListDomainsRequest, ListDomainsResponse](
        "listDomains",
        api.listDomains
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.ListDomainsResponse.wrap)
        .provideEnvironment(r)
    def updateField(
        request: zio.aws.connectcases.model.UpdateFieldRequest
    ): IO[AwsError, zio.aws.connectcases.model.UpdateFieldResponse.ReadOnly] =
      asyncRequestResponse[UpdateFieldRequest, UpdateFieldResponse](
        "updateField",
        api.updateField
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.UpdateFieldResponse.wrap)
        .provideEnvironment(r)
    def listTemplates(
        request: zio.aws.connectcases.model.ListTemplatesRequest
    ): IO[AwsError, zio.aws.connectcases.model.ListTemplatesResponse.ReadOnly] =
      asyncRequestResponse[ListTemplatesRequest, ListTemplatesResponse](
        "listTemplates",
        api.listTemplates
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.ListTemplatesResponse.wrap)
        .provideEnvironment(r)
    def searchCases(
        request: zio.aws.connectcases.model.SearchCasesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      SearchCasesRequest,
      SearchCasesResponseItem,
      SearchCasesPublisher
    ]("searchCases", api.searchCasesPaginator, _.cases())(
      request.buildAwsValue()
    ).map(item => zio.aws.connectcases.model.SearchCasesResponseItem.wrap(item))
      .provideEnvironment(r)
    def searchCasesPaginated(
        request: zio.aws.connectcases.model.SearchCasesRequest
    ): IO[AwsError, zio.aws.connectcases.model.SearchCasesResponse.ReadOnly] =
      asyncRequestResponse[SearchCasesRequest, SearchCasesResponse](
        "searchCases",
        api.searchCases
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.SearchCasesResponse.wrap)
        .provideEnvironment(r)
    def listFieldOptions(
        request: zio.aws.connectcases.model.ListFieldOptionsRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.ListFieldOptionsResponse.ReadOnly
    ] = asyncRequestResponse[ListFieldOptionsRequest, ListFieldOptionsResponse](
      "listFieldOptions",
      api.listFieldOptions
    )(request.buildAwsValue())
      .map(zio.aws.connectcases.model.ListFieldOptionsResponse.wrap)
      .provideEnvironment(r)
    def createDomain(
        request: zio.aws.connectcases.model.CreateDomainRequest
    ): IO[AwsError, zio.aws.connectcases.model.CreateDomainResponse.ReadOnly] =
      asyncRequestResponse[CreateDomainRequest, CreateDomainResponse](
        "createDomain",
        api.createDomain
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.CreateDomainResponse.wrap)
        .provideEnvironment(r)
    def searchRelatedItems(
        request: zio.aws.connectcases.model.SearchRelatedItemsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      SearchRelatedItemsRequest,
      SearchRelatedItemsResponseItem,
      SearchRelatedItemsPublisher
    ]("searchRelatedItems", api.searchRelatedItemsPaginator, _.relatedItems())(
      request.buildAwsValue()
    ).map(item =>
      zio.aws.connectcases.model.SearchRelatedItemsResponseItem.wrap(item)
    ).provideEnvironment(r)
    def searchRelatedItemsPaginated(
        request: zio.aws.connectcases.model.SearchRelatedItemsRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.SearchRelatedItemsResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchRelatedItemsRequest,
      SearchRelatedItemsResponse
    ]("searchRelatedItems", api.searchRelatedItems)(request.buildAwsValue())
      .map(zio.aws.connectcases.model.SearchRelatedItemsResponse.wrap)
      .provideEnvironment(r)
    def batchGetField(
        request: zio.aws.connectcases.model.BatchGetFieldRequest
    ): IO[AwsError, zio.aws.connectcases.model.BatchGetFieldResponse.ReadOnly] =
      asyncRequestResponse[BatchGetFieldRequest, BatchGetFieldResponse](
        "batchGetField",
        api.batchGetField
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.BatchGetFieldResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.connectcases.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putCaseEventConfiguration(
        request: zio.aws.connectcases.model.PutCaseEventConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.PutCaseEventConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      PutCaseEventConfigurationRequest,
      PutCaseEventConfigurationResponse
    ]("putCaseEventConfiguration", api.putCaseEventConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.connectcases.model.PutCaseEventConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listCasesForContact(
        request: zio.aws.connectcases.model.ListCasesForContactRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.ListCasesForContactResponse.ReadOnly
    ] = asyncRequestResponse[
      ListCasesForContactRequest,
      ListCasesForContactResponse
    ]("listCasesForContact", api.listCasesForContact)(request.buildAwsValue())
      .map(zio.aws.connectcases.model.ListCasesForContactResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.connectcases.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.connectcases.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.connectcases.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.connectcases.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createCase(
        request: zio.aws.connectcases.model.CreateCaseRequest
    ): IO[AwsError, zio.aws.connectcases.model.CreateCaseResponse.ReadOnly] =
      asyncRequestResponse[CreateCaseRequest, CreateCaseResponse](
        "createCase",
        api.createCase
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.CreateCaseResponse.wrap)
        .provideEnvironment(r)
    def listFields(
        request: zio.aws.connectcases.model.ListFieldsRequest
    ): IO[AwsError, zio.aws.connectcases.model.ListFieldsResponse.ReadOnly] =
      asyncRequestResponse[ListFieldsRequest, ListFieldsResponse](
        "listFields",
        api.listFields
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.ListFieldsResponse.wrap)
        .provideEnvironment(r)
    def getTemplate(
        request: zio.aws.connectcases.model.GetTemplateRequest
    ): IO[AwsError, zio.aws.connectcases.model.GetTemplateResponse.ReadOnly] =
      asyncRequestResponse[GetTemplateRequest, GetTemplateResponse](
        "getTemplate",
        api.getTemplate
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.GetTemplateResponse.wrap)
        .provideEnvironment(r)
    def createField(
        request: zio.aws.connectcases.model.CreateFieldRequest
    ): IO[AwsError, zio.aws.connectcases.model.CreateFieldResponse.ReadOnly] =
      asyncRequestResponse[CreateFieldRequest, CreateFieldResponse](
        "createField",
        api.createField
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.CreateFieldResponse.wrap)
        .provideEnvironment(r)
    def createLayout(
        request: zio.aws.connectcases.model.CreateLayoutRequest
    ): IO[AwsError, zio.aws.connectcases.model.CreateLayoutResponse.ReadOnly] =
      asyncRequestResponse[CreateLayoutRequest, CreateLayoutResponse](
        "createLayout",
        api.createLayout
      )(request.buildAwsValue())
        .map(zio.aws.connectcases.model.CreateLayoutResponse.wrap)
        .provideEnvironment(r)
  }
  def batchPutFieldOptions(
      request: zio.aws.connectcases.model.BatchPutFieldOptionsRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.BatchPutFieldOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchPutFieldOptions(request))
  def updateLayout(
      request: zio.aws.connectcases.model.UpdateLayoutRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.UpdateLayoutResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLayout(request))
  def listLayouts(request: zio.aws.connectcases.model.ListLayoutsRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.ListLayoutsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLayouts(request))
  def getCaseEventConfiguration(
      request: zio.aws.connectcases.model.GetCaseEventConfigurationRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.GetCaseEventConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCaseEventConfiguration(request))
  def updateTemplate(
      request: zio.aws.connectcases.model.UpdateTemplateRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.UpdateTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTemplate(request))
  def getLayout(request: zio.aws.connectcases.model.GetLayoutRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.GetLayoutResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLayout(request))
  def createRelatedItem(
      request: zio.aws.connectcases.model.CreateRelatedItemRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.CreateRelatedItemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRelatedItem(request))
  def getCase(
      request: zio.aws.connectcases.model.GetCaseRequest
  ): ZIO[zio.aws.connectcases.ConnectCases, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getCase(request))
  def getDomain(request: zio.aws.connectcases.model.GetDomainRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.GetDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomain(request))
  def createTemplate(
      request: zio.aws.connectcases.model.CreateTemplateRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.CreateTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTemplate(request))
  def updateCase(request: zio.aws.connectcases.model.UpdateCaseRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.UpdateCaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCase(request))
  def listDomains(request: zio.aws.connectcases.model.ListDomainsRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.ListDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomains(request))
  def updateField(request: zio.aws.connectcases.model.UpdateFieldRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.UpdateFieldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateField(request))
  def listTemplates(
      request: zio.aws.connectcases.model.ListTemplatesRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.ListTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTemplates(request))
  def searchCases(
      request: zio.aws.connectcases.model.SearchCasesRequest
  ): ZStream[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.SearchCasesResponseItem.ReadOnly
  ] = ZStream.serviceWithStream(_.searchCases(request))
  def searchCasesPaginated(
      request: zio.aws.connectcases.model.SearchCasesRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.SearchCasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchCasesPaginated(request))
  def listFieldOptions(
      request: zio.aws.connectcases.model.ListFieldOptionsRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.ListFieldOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFieldOptions(request))
  def createDomain(
      request: zio.aws.connectcases.model.CreateDomainRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.CreateDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDomain(request))
  def searchRelatedItems(
      request: zio.aws.connectcases.model.SearchRelatedItemsRequest
  ): ZStream[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.SearchRelatedItemsResponseItem.ReadOnly
  ] = ZStream.serviceWithStream(_.searchRelatedItems(request))
  def searchRelatedItemsPaginated(
      request: zio.aws.connectcases.model.SearchRelatedItemsRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.SearchRelatedItemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchRelatedItemsPaginated(request))
  def batchGetField(
      request: zio.aws.connectcases.model.BatchGetFieldRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.BatchGetFieldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetField(request))
  def untagResource(
      request: zio.aws.connectcases.model.UntagResourceRequest
  ): ZIO[zio.aws.connectcases.ConnectCases, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def putCaseEventConfiguration(
      request: zio.aws.connectcases.model.PutCaseEventConfigurationRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.PutCaseEventConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putCaseEventConfiguration(request))
  def listCasesForContact(
      request: zio.aws.connectcases.model.ListCasesForContactRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.ListCasesForContactResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCasesForContact(request))
  def listTagsForResource(
      request: zio.aws.connectcases.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.connectcases.model.TagResourceRequest
  ): ZIO[zio.aws.connectcases.ConnectCases, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createCase(request: zio.aws.connectcases.model.CreateCaseRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.CreateCaseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCase(request))
  def listFields(request: zio.aws.connectcases.model.ListFieldsRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.ListFieldsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFields(request))
  def getTemplate(request: zio.aws.connectcases.model.GetTemplateRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.GetTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplate(request))
  def createField(request: zio.aws.connectcases.model.CreateFieldRequest): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.CreateFieldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createField(request))
  def createLayout(
      request: zio.aws.connectcases.model.CreateLayoutRequest
  ): ZIO[
    zio.aws.connectcases.ConnectCases,
    AwsError,
    zio.aws.connectcases.model.CreateLayoutResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLayout(request))
}
