package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{ClientToken, EvaluationTimeout}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartResourceEvaluationRequest(
    resourceDetails: zio.aws.config.model.ResourceDetails,
    evaluationContext: Optional[zio.aws.config.model.EvaluationContext] =
      Optional.Absent,
    evaluationMode: zio.aws.config.model.EvaluationMode,
    evaluationTimeout: Optional[EvaluationTimeout] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest = {
    import StartResourceEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest
      .builder()
      .resourceDetails(resourceDetails.buildAwsValue())
      .optionallyWith(evaluationContext.map(value => value.buildAwsValue()))(
        _.evaluationContext
      )
      .evaluationMode(evaluationMode.unwrap)
      .optionallyWith(
        evaluationTimeout.map(value => EvaluationTimeout.unwrap(value): Integer)
      )(_.evaluationTimeout)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.config.model.StartResourceEvaluationRequest.ReadOnly =
    zio.aws.config.model.StartResourceEvaluationRequest.wrap(buildAwsValue())
}
object StartResourceEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StartResourceEvaluationRequest =
      zio.aws.config.model.StartResourceEvaluationRequest(
        resourceDetails.asEditable,
        evaluationContext.map(value => value.asEditable),
        evaluationMode,
        evaluationTimeout.map(value => value),
        clientToken.map(value => value)
      )
    def resourceDetails: zio.aws.config.model.ResourceDetails.ReadOnly
    def evaluationContext
        : Optional[zio.aws.config.model.EvaluationContext.ReadOnly]
    def evaluationMode: zio.aws.config.model.EvaluationMode
    def evaluationTimeout: Optional[EvaluationTimeout]
    def clientToken: Optional[ClientToken]
    def getResourceDetails
        : ZIO[Any, Nothing, zio.aws.config.model.ResourceDetails.ReadOnly] =
      ZIO.succeed(resourceDetails)
    def getEvaluationContext
        : ZIO[Any, AwsError, zio.aws.config.model.EvaluationContext.ReadOnly] =
      AwsError.unwrapOptionField("evaluationContext", evaluationContext)
    def getEvaluationMode
        : ZIO[Any, Nothing, zio.aws.config.model.EvaluationMode] =
      ZIO.succeed(evaluationMode)
    def getEvaluationTimeout: ZIO[Any, AwsError, EvaluationTimeout] =
      AwsError.unwrapOptionField("evaluationTimeout", evaluationTimeout)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest
  ) extends zio.aws.config.model.StartResourceEvaluationRequest.ReadOnly {
    override val resourceDetails
        : zio.aws.config.model.ResourceDetails.ReadOnly =
      zio.aws.config.model.ResourceDetails.wrap(impl.resourceDetails())
    override val evaluationContext
        : Optional[zio.aws.config.model.EvaluationContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationContext())
        .map(value => zio.aws.config.model.EvaluationContext.wrap(value))
    override val evaluationMode: zio.aws.config.model.EvaluationMode =
      zio.aws.config.model.EvaluationMode.wrap(impl.evaluationMode())
    override val evaluationTimeout: Optional[EvaluationTimeout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationTimeout())
        .map(value => zio.aws.config.model.primitives.EvaluationTimeout(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.config.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest
  ): zio.aws.config.model.StartResourceEvaluationRequest.ReadOnly = new Wrapper(
    impl
  )
}
