package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.EvaluationContextIdentifier
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluationContext(
    evaluationContextIdentifier: Optional[EvaluationContextIdentifier] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.EvaluationContext = {
    import EvaluationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.EvaluationContext
      .builder()
      .optionallyWith(
        evaluationContextIdentifier.map(value =>
          EvaluationContextIdentifier.unwrap(value): java.lang.String
        )
      )(_.evaluationContextIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.config.model.EvaluationContext.ReadOnly =
    zio.aws.config.model.EvaluationContext.wrap(buildAwsValue())
}
object EvaluationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.EvaluationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.EvaluationContext =
      zio.aws.config.model
        .EvaluationContext(evaluationContextIdentifier.map(value => value))
    def evaluationContextIdentifier: Optional[EvaluationContextIdentifier]
    def getEvaluationContextIdentifier
        : ZIO[Any, AwsError, EvaluationContextIdentifier] =
      AwsError.unwrapOptionField(
        "evaluationContextIdentifier",
        evaluationContextIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.EvaluationContext
  ) extends zio.aws.config.model.EvaluationContext.ReadOnly {
    override val evaluationContextIdentifier
        : Optional[EvaluationContextIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationContextIdentifier())
      .map(value =>
        zio.aws.config.model.primitives.EvaluationContextIdentifier(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.EvaluationContext
  ): zio.aws.config.model.EvaluationContext.ReadOnly = new Wrapper(impl)
}
