package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  NextToken,
  PageSizeLimit,
  ConformancePackName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeConformancePackStatusRequest(
    conformancePackNames: Optional[Iterable[ConformancePackName]] =
      Optional.Absent,
    limit: Optional[PageSizeLimit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest = {
    import DescribeConformancePackStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest
      .builder()
      .optionallyWith(
        conformancePackNames.map(value =>
          value.map { item =>
            ConformancePackName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.conformancePackNames)
      .optionallyWith(limit.map(value => PageSizeLimit.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConformancePackStatusRequest.ReadOnly =
    zio.aws.config.model.DescribeConformancePackStatusRequest
      .wrap(buildAwsValue())
}
object DescribeConformancePackStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeConformancePackStatusRequest =
      zio.aws.config.model.DescribeConformancePackStatusRequest(
        conformancePackNames.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def conformancePackNames: Optional[List[ConformancePackName]]
    def limit: Optional[PageSizeLimit]
    def nextToken: Optional[NextToken]
    def getConformancePackNames: ZIO[Any, AwsError, List[ConformancePackName]] =
      AwsError.unwrapOptionField("conformancePackNames", conformancePackNames)
    def getLimit: ZIO[Any, AwsError, PageSizeLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest
  ) extends zio.aws.config.model.DescribeConformancePackStatusRequest.ReadOnly {
    override val conformancePackNames: Optional[List[ConformancePackName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conformancePackNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.ConformancePackName(item)
          }.toList
        )
    override val limit: Optional[PageSizeLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.PageSizeLimit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest
  ): zio.aws.config.model.DescribeConformancePackStatusRequest.ReadOnly =
    new Wrapper(impl)
}
