package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeliverConfigSnapshotResponse(
    configSnapshotId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse = {
    import DeliverConfigSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse
      .builder()
      .optionallyWith(configSnapshotId.map(value => value: java.lang.String))(
        _.configSnapshotId
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeliverConfigSnapshotResponse.ReadOnly =
    zio.aws.config.model.DeliverConfigSnapshotResponse.wrap(buildAwsValue())
}
object DeliverConfigSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeliverConfigSnapshotResponse =
      zio.aws.config.model
        .DeliverConfigSnapshotResponse(configSnapshotId.map(value => value))
    def configSnapshotId: Optional[String]
    def getConfigSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configSnapshotId", configSnapshotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse
  ) extends zio.aws.config.model.DeliverConfigSnapshotResponse.ReadOnly {
    override val configSnapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configSnapshotId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse
  ): zio.aws.config.model.DeliverConfigSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
