package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConfigurationAggregatorName
import scala.jdk.CollectionConverters.*
final case class BatchGetAggregateResourceConfigRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    resourceIdentifiers: Iterable[
      zio.aws.config.model.AggregateResourceIdentifier
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest = {
    import BatchGetAggregateResourceConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .resourceIdentifiers(resourceIdentifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.BatchGetAggregateResourceConfigRequest.ReadOnly =
    zio.aws.config.model.BatchGetAggregateResourceConfigRequest
      .wrap(buildAwsValue())
}
object BatchGetAggregateResourceConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.BatchGetAggregateResourceConfigRequest =
      zio.aws.config.model.BatchGetAggregateResourceConfigRequest(
        configurationAggregatorName,
        resourceIdentifiers.map { item =>
          item.asEditable
        }
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def resourceIdentifiers
        : List[zio.aws.config.model.AggregateResourceIdentifier.ReadOnly]
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getResourceIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
    ]] = ZIO.succeed(resourceIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest
  ) extends zio.aws.config.model.BatchGetAggregateResourceConfigRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val resourceIdentifiers
        : List[zio.aws.config.model.AggregateResourceIdentifier.ReadOnly] = impl
      .resourceIdentifiers()
      .asScala
      .map { item =>
        zio.aws.config.model.AggregateResourceIdentifier.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest
  ): zio.aws.config.model.BatchGetAggregateResourceConfigRequest.ReadOnly =
    new Wrapper(impl)
}
