package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutOrganizationConfigRuleResponse(
    organizationConfigRuleArn: Optional[StringWithCharLimit256] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse = {
    import PutOrganizationConfigRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse
      .builder()
      .optionallyWith(
        organizationConfigRuleArn.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.organizationConfigRuleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutOrganizationConfigRuleResponse.ReadOnly =
    zio.aws.config.model.PutOrganizationConfigRuleResponse.wrap(buildAwsValue())
}
object PutOrganizationConfigRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutOrganizationConfigRuleResponse =
      zio.aws.config.model.PutOrganizationConfigRuleResponse(
        organizationConfigRuleArn.map(value => value)
      )
    def organizationConfigRuleArn: Optional[StringWithCharLimit256]
    def getOrganizationConfigRuleArn
        : ZIO[Any, AwsError, StringWithCharLimit256] = AwsError
      .unwrapOptionField("organizationConfigRuleArn", organizationConfigRuleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse
  ) extends zio.aws.config.model.PutOrganizationConfigRuleResponse.ReadOnly {
    override val organizationConfigRuleArn: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationConfigRuleArn())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse
  ): zio.aws.config.model.PutOrganizationConfigRuleResponse.ReadOnly =
    new Wrapper(impl)
}
