package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait MaximumExecutionFrequency {
  def unwrap
      : software.amazon.awssdk.services.config.model.MaximumExecutionFrequency
}
object MaximumExecutionFrequency {
  def wrap(
      value: software.amazon.awssdk.services.config.model.MaximumExecutionFrequency
  ): zio.aws.config.model.MaximumExecutionFrequency = value match {
    case software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.ONE_HOUR =>
      val r = One_Hour
      r
    case software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.THREE_HOURS =>
      val r = Three_Hours
      r
    case software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.SIX_HOURS =>
      val r = Six_Hours
      r
    case software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.TWELVE_HOURS =>
      val r = Twelve_Hours
      r
    case software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.TWENTY_FOUR_HOURS =>
      val r = TwentyFour_Hours
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.MaximumExecutionFrequency {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MaximumExecutionFrequency =
      software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.UNKNOWN_TO_SDK_VERSION
  }
  case object One_Hour extends zio.aws.config.model.MaximumExecutionFrequency {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MaximumExecutionFrequency =
      software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.ONE_HOUR
  }
  case object Three_Hours
      extends zio.aws.config.model.MaximumExecutionFrequency {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MaximumExecutionFrequency =
      software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.THREE_HOURS
  }
  case object Six_Hours extends zio.aws.config.model.MaximumExecutionFrequency {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MaximumExecutionFrequency =
      software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.SIX_HOURS
  }
  case object Twelve_Hours
      extends zio.aws.config.model.MaximumExecutionFrequency {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MaximumExecutionFrequency =
      software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.TWELVE_HOURS
  }
  case object TwentyFour_Hours
      extends zio.aws.config.model.MaximumExecutionFrequency {
    override def unwrap
        : software.amazon.awssdk.services.config.model.MaximumExecutionFrequency =
      software.amazon.awssdk.services.config.model.MaximumExecutionFrequency.TWENTY_FOUR_HOURS
  }
}
