package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{NextToken, PageSizeLimit}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListConformancePackComplianceScoresRequest(
    filters: Optional[
      zio.aws.config.model.ConformancePackComplianceScoresFilters
    ] = Optional.Absent,
    sortOrder: Optional[zio.aws.config.model.SortOrder] = Optional.Absent,
    sortBy: Optional[zio.aws.config.model.SortBy] = Optional.Absent,
    limit: Optional[PageSizeLimit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest = {
    import ListConformancePackComplianceScoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest
      .builder()
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(limit.map(value => PageSizeLimit.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.ListConformancePackComplianceScoresRequest.ReadOnly =
    zio.aws.config.model.ListConformancePackComplianceScoresRequest
      .wrap(buildAwsValue())
}
object ListConformancePackComplianceScoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.ListConformancePackComplianceScoresRequest =
      zio.aws.config.model.ListConformancePackComplianceScoresRequest(
        filters.map(value => value.asEditable),
        sortOrder.map(value => value),
        sortBy.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[
      zio.aws.config.model.ConformancePackComplianceScoresFilters.ReadOnly
    ]
    def sortOrder: Optional[zio.aws.config.model.SortOrder]
    def sortBy: Optional[zio.aws.config.model.SortBy]
    def limit: Optional[PageSizeLimit]
    def nextToken: Optional[NextToken]
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceScoresFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.config.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getSortBy: ZIO[Any, AwsError, zio.aws.config.model.SortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getLimit: ZIO[Any, AwsError, PageSizeLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest
  ) extends zio.aws.config.model.ListConformancePackComplianceScoresRequest.ReadOnly {
    override val filters: Optional[
      zio.aws.config.model.ConformancePackComplianceScoresFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        zio.aws.config.model.ConformancePackComplianceScoresFilters.wrap(value)
      )
    override val sortOrder: Optional[zio.aws.config.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.config.model.SortOrder.wrap(value))
    override val sortBy: Optional[zio.aws.config.model.SortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.config.model.SortBy.wrap(value))
    override val limit: Optional[PageSizeLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.PageSizeLimit(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest
  ): zio.aws.config.model.ListConformancePackComplianceScoresRequest.ReadOnly =
    new Wrapper(impl)
}
