package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExclusionByResourceTypes(
    resourceTypes: Optional[Iterable[zio.aws.config.model.ResourceType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ExclusionByResourceTypes = {
    import ExclusionByResourceTypes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ExclusionByResourceTypes
      .builder()
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ExclusionByResourceTypes.ReadOnly =
    zio.aws.config.model.ExclusionByResourceTypes.wrap(buildAwsValue())
}
object ExclusionByResourceTypes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ExclusionByResourceTypes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ExclusionByResourceTypes =
      zio.aws.config.model
        .ExclusionByResourceTypes(resourceTypes.map(value => value))
    def resourceTypes: Optional[List[zio.aws.config.model.ResourceType]]
    def getResourceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ExclusionByResourceTypes
  ) extends zio.aws.config.model.ExclusionByResourceTypes.ReadOnly {
    override val resourceTypes
        : Optional[List[zio.aws.config.model.ResourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ResourceType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ExclusionByResourceTypes
  ): zio.aws.config.model.ExclusionByResourceTypes.ReadOnly = new Wrapper(impl)
}
