package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit1024
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluationStatus(
    status: zio.aws.config.model.ResourceEvaluationStatus,
    failureReason: Optional[StringWithCharLimit1024] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.EvaluationStatus = {
    import EvaluationStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.EvaluationStatus
      .builder()
      .status(status.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          StringWithCharLimit1024.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.config.model.EvaluationStatus.ReadOnly =
    zio.aws.config.model.EvaluationStatus.wrap(buildAwsValue())
}
object EvaluationStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.EvaluationStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.EvaluationStatus = zio.aws.config.model
      .EvaluationStatus(status, failureReason.map(value => value))
    def status: zio.aws.config.model.ResourceEvaluationStatus
    def failureReason: Optional[StringWithCharLimit1024]
    def getStatus
        : ZIO[Any, Nothing, zio.aws.config.model.ResourceEvaluationStatus] =
      ZIO.succeed(status)
    def getFailureReason: ZIO[Any, AwsError, StringWithCharLimit1024] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.EvaluationStatus
  ) extends zio.aws.config.model.EvaluationStatus.ReadOnly {
    override val status: zio.aws.config.model.ResourceEvaluationStatus =
      zio.aws.config.model.ResourceEvaluationStatus.wrap(impl.status())
    override val failureReason: Optional[StringWithCharLimit1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit1024(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.EvaluationStatus
  ): zio.aws.config.model.EvaluationStatus.ReadOnly = new Wrapper(impl)
}
