package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluationModeConfiguration(
    mode: Optional[zio.aws.config.model.EvaluationMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.EvaluationModeConfiguration = {
    import EvaluationModeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.EvaluationModeConfiguration
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly: zio.aws.config.model.EvaluationModeConfiguration.ReadOnly =
    zio.aws.config.model.EvaluationModeConfiguration.wrap(buildAwsValue())
}
object EvaluationModeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.EvaluationModeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.EvaluationModeConfiguration =
      zio.aws.config.model.EvaluationModeConfiguration(mode.map(value => value))
    def mode: Optional[zio.aws.config.model.EvaluationMode]
    def getMode: ZIO[Any, AwsError, zio.aws.config.model.EvaluationMode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.EvaluationModeConfiguration
  ) extends zio.aws.config.model.EvaluationModeConfiguration.ReadOnly {
    override val mode: Optional[zio.aws.config.model.EvaluationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.config.model.EvaluationMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.EvaluationModeConfiguration
  ): zio.aws.config.model.EvaluationModeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
