package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait EvaluationMode {
  def unwrap: software.amazon.awssdk.services.config.model.EvaluationMode
}
object EvaluationMode {
  def wrap(
      value: software.amazon.awssdk.services.config.model.EvaluationMode
  ): zio.aws.config.model.EvaluationMode = value match {
    case software.amazon.awssdk.services.config.model.EvaluationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.EvaluationMode.DETECTIVE =>
      val r = DETECTIVE
      r
    case software.amazon.awssdk.services.config.model.EvaluationMode.PROACTIVE =>
      val r = PROACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.config.model.EvaluationMode {
    override def unwrap
        : software.amazon.awssdk.services.config.model.EvaluationMode =
      software.amazon.awssdk.services.config.model.EvaluationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DETECTIVE extends zio.aws.config.model.EvaluationMode {
    override def unwrap
        : software.amazon.awssdk.services.config.model.EvaluationMode =
      software.amazon.awssdk.services.config.model.EvaluationMode.DETECTIVE
  }
  case object PROACTIVE extends zio.aws.config.model.EvaluationMode {
    override def unwrap
        : software.amazon.awssdk.services.config.model.EvaluationMode =
      software.amazon.awssdk.services.config.model.EvaluationMode.PROACTIVE
  }
}
