package zio.aws.config.model
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  CosmosPageLimit,
  OrganizationConformancePackName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConformancePacksRequest(
    organizationConformancePackNames: Optional[
      Iterable[OrganizationConformancePackName]
    ] = Optional.Absent,
    limit: Optional[CosmosPageLimit] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest = {
    import DescribeOrganizationConformancePacksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest
      .builder()
      .optionallyWith(
        organizationConformancePackNames.map(value =>
          value.map { item =>
            OrganizationConformancePackName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationConformancePackNames)
      .optionallyWith(
        limit.map(value => CosmosPageLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeOrganizationConformancePacksRequest.ReadOnly =
    zio.aws.config.model.DescribeOrganizationConformancePacksRequest
      .wrap(buildAwsValue())
}
object DescribeOrganizationConformancePacksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeOrganizationConformancePacksRequest =
      zio.aws.config.model.DescribeOrganizationConformancePacksRequest(
        organizationConformancePackNames.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def organizationConformancePackNames
        : Optional[List[OrganizationConformancePackName]]
    def limit: Optional[CosmosPageLimit]
    def nextToken: Optional[String]
    def getOrganizationConformancePackNames
        : ZIO[Any, AwsError, List[OrganizationConformancePackName]] =
      AwsError.unwrapOptionField(
        "organizationConformancePackNames",
        organizationConformancePackNames
      )
    def getLimit: ZIO[Any, AwsError, CosmosPageLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest
  ) extends zio.aws.config.model.DescribeOrganizationConformancePacksRequest.ReadOnly {
    override val organizationConformancePackNames
        : Optional[List[OrganizationConformancePackName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationConformancePackNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives
              .OrganizationConformancePackName(item)
          }.toList
        )
    override val limit: Optional[CosmosPageLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.config.model.primitives.CosmosPageLimit(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest
  ): zio.aws.config.model.DescribeOrganizationConformancePacksRequest.ReadOnly =
    new Wrapper(impl)
}
