package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ChannelName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDeliveryChannelStatusRequest(
    deliveryChannelNames: Optional[Iterable[ChannelName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest = {
    import DescribeDeliveryChannelStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest
      .builder()
      .optionallyWith(
        deliveryChannelNames.map(value =>
          value.map { item =>
            ChannelName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deliveryChannelNames)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeDeliveryChannelStatusRequest.ReadOnly =
    zio.aws.config.model.DescribeDeliveryChannelStatusRequest
      .wrap(buildAwsValue())
}
object DescribeDeliveryChannelStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeDeliveryChannelStatusRequest =
      zio.aws.config.model.DescribeDeliveryChannelStatusRequest(
        deliveryChannelNames.map(value => value)
      )
    def deliveryChannelNames: Optional[List[ChannelName]]
    def getDeliveryChannelNames: ZIO[Any, AwsError, List[ChannelName]] =
      AwsError.unwrapOptionField("deliveryChannelNames", deliveryChannelNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest
  ) extends zio.aws.config.model.DescribeDeliveryChannelStatusRequest.ReadOnly {
    override val deliveryChannelNames: Optional[List[ChannelName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryChannelNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.ChannelName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest
  ): zio.aws.config.model.DescribeDeliveryChannelStatusRequest.ReadOnly =
    new Wrapper(impl)
}
