package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{Date, ResourceEvaluationId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ResourceEvaluation(
    resourceEvaluationId: Optional[ResourceEvaluationId] = Optional.Absent,
    evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      Optional.Absent,
    evaluationStartTimestamp: Optional[Date] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceEvaluation = {
    import ResourceEvaluation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceEvaluation
      .builder()
      .optionallyWith(
        resourceEvaluationId.map(value =>
          ResourceEvaluationId.unwrap(value): java.lang.String
        )
      )(_.resourceEvaluationId)
      .optionallyWith(evaluationMode.map(value => value.unwrap))(
        _.evaluationMode
      )
      .optionallyWith(
        evaluationStartTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.evaluationStartTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceEvaluation.ReadOnly =
    zio.aws.config.model.ResourceEvaluation.wrap(buildAwsValue())
}
object ResourceEvaluation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceEvaluation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceEvaluation =
      zio.aws.config.model.ResourceEvaluation(
        resourceEvaluationId.map(value => value),
        evaluationMode.map(value => value),
        evaluationStartTimestamp.map(value => value)
      )
    def resourceEvaluationId: Optional[ResourceEvaluationId]
    def evaluationMode: Optional[zio.aws.config.model.EvaluationMode]
    def evaluationStartTimestamp: Optional[Date]
    def getResourceEvaluationId: ZIO[Any, AwsError, ResourceEvaluationId] =
      AwsError.unwrapOptionField("resourceEvaluationId", resourceEvaluationId)
    def getEvaluationMode
        : ZIO[Any, AwsError, zio.aws.config.model.EvaluationMode] =
      AwsError.unwrapOptionField("evaluationMode", evaluationMode)
    def getEvaluationStartTimestamp: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("evaluationStartTimestamp", evaluationStartTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceEvaluation
  ) extends zio.aws.config.model.ResourceEvaluation.ReadOnly {
    override val resourceEvaluationId: Optional[ResourceEvaluationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceEvaluationId())
        .map(value =>
          zio.aws.config.model.primitives.ResourceEvaluationId(value)
        )
    override val evaluationMode: Optional[zio.aws.config.model.EvaluationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationMode())
        .map(value => zio.aws.config.model.EvaluationMode.wrap(value))
    override val evaluationStartTimestamp: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationStartTimestamp())
        .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceEvaluation
  ): zio.aws.config.model.ResourceEvaluation.ReadOnly = new Wrapper(impl)
}
