package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait RemediationExecutionState {
  def unwrap
      : software.amazon.awssdk.services.config.model.RemediationExecutionState
}
object RemediationExecutionState {
  def wrap(
      value: software.amazon.awssdk.services.config.model.RemediationExecutionState
  ): zio.aws.config.model.RemediationExecutionState = value match {
    case software.amazon.awssdk.services.config.model.RemediationExecutionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.RemediationExecutionState.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.config.model.RemediationExecutionState.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.config.model.RemediationExecutionState.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.config.model.RemediationExecutionState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.RemediationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionState =
      software.amazon.awssdk.services.config.model.RemediationExecutionState.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.config.model.RemediationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionState =
      software.amazon.awssdk.services.config.model.RemediationExecutionState.QUEUED
  }
  case object IN_PROGRESS
      extends zio.aws.config.model.RemediationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionState =
      software.amazon.awssdk.services.config.model.RemediationExecutionState.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.config.model.RemediationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionState =
      software.amazon.awssdk.services.config.model.RemediationExecutionState.SUCCEEDED
  }
  case object FAILED extends zio.aws.config.model.RemediationExecutionState {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RemediationExecutionState =
      software.amazon.awssdk.services.config.model.RemediationExecutionState.FAILED
  }
}
