package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigRuleEvaluationStatusResponse(
    configRulesEvaluationStatus: Optional[
      Iterable[zio.aws.config.model.ConfigRuleEvaluationStatus]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse = {
    import DescribeConfigRuleEvaluationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse
      .builder()
      .optionallyWith(
        configRulesEvaluationStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configRulesEvaluationStatus)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly =
    zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse
      .wrap(buildAwsValue())
}
object DescribeConfigRuleEvaluationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse =
      zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse(
        configRulesEvaluationStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configRulesEvaluationStatus: Optional[
      List[zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getConfigRulesEvaluationStatus: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "configRulesEvaluationStatus",
      configRulesEvaluationStatus
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse
  ) extends zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly {
    override val configRulesEvaluationStatus: Optional[
      List[zio.aws.config.model.ConfigRuleEvaluationStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configRulesEvaluationStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConfigRuleEvaluationStatus.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse
  ): zio.aws.config.model.DescribeConfigRuleEvaluationStatusResponse.ReadOnly =
    new Wrapper(impl)
}
