package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetResourceConfigRequest(
    resourceKeys: Iterable[zio.aws.config.model.ResourceKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest = {
    import BatchGetResourceConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest
      .builder()
      .resourceKeys(resourceKeys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.config.model.BatchGetResourceConfigRequest.ReadOnly =
    zio.aws.config.model.BatchGetResourceConfigRequest.wrap(buildAwsValue())
}
object BatchGetResourceConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.BatchGetResourceConfigRequest =
      zio.aws.config.model.BatchGetResourceConfigRequest(resourceKeys.map {
        item =>
          item.asEditable
      })
    def resourceKeys: List[zio.aws.config.model.ResourceKey.ReadOnly]
    def getResourceKeys
        : ZIO[Any, Nothing, List[zio.aws.config.model.ResourceKey.ReadOnly]] =
      ZIO.succeed(resourceKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest
  ) extends zio.aws.config.model.BatchGetResourceConfigRequest.ReadOnly {
    override val resourceKeys: List[zio.aws.config.model.ResourceKey.ReadOnly] =
      impl
        .resourceKeys()
        .asScala
        .map { item =>
          zio.aws.config.model.ResourceKey.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest
  ): zio.aws.config.model.BatchGetResourceConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
