package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  ResourceDeletionTime,
  ResourceName,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ResourceIdentifier(
    resourceType: Optional[zio.aws.config.model.ResourceType] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    resourceName: Optional[ResourceName] = Optional.Absent,
    resourceDeletionTime: Optional[ResourceDeletionTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceIdentifier = {
    import ResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceIdentifier
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(
        resourceDeletionTime.map(value =>
          ResourceDeletionTime.unwrap(value): Instant
        )
      )(_.resourceDeletionTime)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceIdentifier.ReadOnly =
    zio.aws.config.model.ResourceIdentifier.wrap(buildAwsValue())
}
object ResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceIdentifier =
      zio.aws.config.model.ResourceIdentifier(
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceName.map(value => value),
        resourceDeletionTime.map(value => value)
      )
    def resourceType: Optional[zio.aws.config.model.ResourceType]
    def resourceId: Optional[ResourceId]
    def resourceName: Optional[ResourceName]
    def resourceDeletionTime: Optional[ResourceDeletionTime]
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceDeletionTime: ZIO[Any, AwsError, ResourceDeletionTime] =
      AwsError.unwrapOptionField("resourceDeletionTime", resourceDeletionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceIdentifier
  ) extends zio.aws.config.model.ResourceIdentifier.ReadOnly {
    override val resourceType: Optional[zio.aws.config.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.ResourceId(value))
    override val resourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
    override val resourceDeletionTime: Optional[ResourceDeletionTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDeletionTime())
        .map(value =>
          zio.aws.config.model.primitives.ResourceDeletionTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceIdentifier
  ): zio.aws.config.model.ResourceIdentifier.ReadOnly = new Wrapper(impl)
}
