package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AwsRegion, AccountId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceCountFilters(
    resourceType: Optional[zio.aws.config.model.ResourceType] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    region: Optional[AwsRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceCountFilters = {
    import ResourceCountFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceCountFilters
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        region.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceCountFilters.ReadOnly =
    zio.aws.config.model.ResourceCountFilters.wrap(buildAwsValue())
}
object ResourceCountFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceCountFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceCountFilters =
      zio.aws.config.model.ResourceCountFilters(
        resourceType.map(value => value),
        accountId.map(value => value),
        region.map(value => value)
      )
    def resourceType: Optional[zio.aws.config.model.ResourceType]
    def accountId: Optional[AccountId]
    def region: Optional[AwsRegion]
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceCountFilters
  ) extends zio.aws.config.model.ResourceCountFilters.ReadOnly {
    override val resourceType: Optional[zio.aws.config.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val region: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceCountFilters
  ): zio.aws.config.model.ResourceCountFilters.ReadOnly = new Wrapper(impl)
}
