package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AwsRegion, AccountId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutAggregationAuthorizationRequest(
    authorizedAccountId: AccountId,
    authorizedAwsRegion: AwsRegion,
    tags: Optional[Iterable[zio.aws.config.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest = {
    import PutAggregationAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest
      .builder()
      .authorizedAccountId(
        AccountId.unwrap(authorizedAccountId): java.lang.String
      )
      .authorizedAwsRegion(
        AwsRegion.unwrap(authorizedAwsRegion): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutAggregationAuthorizationRequest.ReadOnly =
    zio.aws.config.model.PutAggregationAuthorizationRequest
      .wrap(buildAwsValue())
}
object PutAggregationAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutAggregationAuthorizationRequest =
      zio.aws.config.model.PutAggregationAuthorizationRequest(
        authorizedAccountId,
        authorizedAwsRegion,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def authorizedAccountId: AccountId
    def authorizedAwsRegion: AwsRegion
    def tags: Optional[List[zio.aws.config.model.Tag.ReadOnly]]
    def getAuthorizedAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(authorizedAccountId)
    def getAuthorizedAwsRegion: ZIO[Any, Nothing, AwsRegion] =
      ZIO.succeed(authorizedAwsRegion)
    def getTags: ZIO[Any, AwsError, List[zio.aws.config.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest
  ) extends zio.aws.config.model.PutAggregationAuthorizationRequest.ReadOnly {
    override val authorizedAccountId: AccountId =
      zio.aws.config.model.primitives.AccountId(impl.authorizedAccountId())
    override val authorizedAwsRegion: AwsRegion =
      zio.aws.config.model.primitives.AwsRegion(impl.authorizedAwsRegion())
    override val tags: Optional[List[zio.aws.config.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest
  ): zio.aws.config.model.PutAggregationAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
