package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ResourceEvaluationId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartResourceEvaluationResponse(
    resourceEvaluationId: Optional[ResourceEvaluationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse = {
    import StartResourceEvaluationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse
      .builder()
      .optionallyWith(
        resourceEvaluationId.map(value =>
          ResourceEvaluationId.unwrap(value): java.lang.String
        )
      )(_.resourceEvaluationId)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.StartResourceEvaluationResponse.ReadOnly =
    zio.aws.config.model.StartResourceEvaluationResponse.wrap(buildAwsValue())
}
object StartResourceEvaluationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StartResourceEvaluationResponse =
      zio.aws.config.model.StartResourceEvaluationResponse(
        resourceEvaluationId.map(value => value)
      )
    def resourceEvaluationId: Optional[ResourceEvaluationId]
    def getResourceEvaluationId: ZIO[Any, AwsError, ResourceEvaluationId] =
      AwsError.unwrapOptionField("resourceEvaluationId", resourceEvaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse
  ) extends zio.aws.config.model.StartResourceEvaluationResponse.ReadOnly {
    override val resourceEvaluationId: Optional[ResourceEvaluationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceEvaluationId())
        .map(value =>
          zio.aws.config.model.primitives.ResourceEvaluationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse
  ): zio.aws.config.model.StartResourceEvaluationResponse.ReadOnly =
    new Wrapper(impl)
}
