package zio.aws.config.model
import scala.jdk.CollectionConverters.*
sealed trait RecordingStrategyType {
  def unwrap: software.amazon.awssdk.services.config.model.RecordingStrategyType
}
object RecordingStrategyType {
  def wrap(
      value: software.amazon.awssdk.services.config.model.RecordingStrategyType
  ): zio.aws.config.model.RecordingStrategyType = value match {
    case software.amazon.awssdk.services.config.model.RecordingStrategyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.config.model.RecordingStrategyType.ALL_SUPPORTED_RESOURCE_TYPES =>
      val r = ALL_SUPPORTED_RESOURCE_TYPES
      r
    case software.amazon.awssdk.services.config.model.RecordingStrategyType.INCLUSION_BY_RESOURCE_TYPES =>
      val r = INCLUSION_BY_RESOURCE_TYPES
      r
    case software.amazon.awssdk.services.config.model.RecordingStrategyType.EXCLUSION_BY_RESOURCE_TYPES =>
      val r = EXCLUSION_BY_RESOURCE_TYPES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.config.model.RecordingStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RecordingStrategyType =
      software.amazon.awssdk.services.config.model.RecordingStrategyType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL_SUPPORTED_RESOURCE_TYPES
      extends zio.aws.config.model.RecordingStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RecordingStrategyType =
      software.amazon.awssdk.services.config.model.RecordingStrategyType.ALL_SUPPORTED_RESOURCE_TYPES
  }
  case object INCLUSION_BY_RESOURCE_TYPES
      extends zio.aws.config.model.RecordingStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RecordingStrategyType =
      software.amazon.awssdk.services.config.model.RecordingStrategyType.INCLUSION_BY_RESOURCE_TYPES
  }
  case object EXCLUSION_BY_RESOURCE_TYPES
      extends zio.aws.config.model.RecordingStrategyType {
    override def unwrap
        : software.amazon.awssdk.services.config.model.RecordingStrategyType =
      software.amazon.awssdk.services.config.model.RecordingStrategyType.EXCLUSION_BY_RESOURCE_TYPES
  }
}
