package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConfigRuleName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigRulesRequest(
    configRuleNames: Optional[Iterable[ConfigRuleName]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    filters: Optional[zio.aws.config.model.DescribeConfigRulesFilters] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest = {
    import DescribeConfigRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest
      .builder()
      .optionallyWith(
        configRuleNames.map(value =>
          value.map { item =>
            ConfigRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configRuleNames)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.config.model.DescribeConfigRulesRequest.ReadOnly =
    zio.aws.config.model.DescribeConfigRulesRequest.wrap(buildAwsValue())
}
object DescribeConfigRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeConfigRulesRequest =
      zio.aws.config.model.DescribeConfigRulesRequest(
        configRuleNames.map(value => value),
        nextToken.map(value => value),
        filters.map(value => value.asEditable)
      )
    def configRuleNames: Optional[List[ConfigRuleName]]
    def nextToken: Optional[String]
    def filters
        : Optional[zio.aws.config.model.DescribeConfigRulesFilters.ReadOnly]
    def getConfigRuleNames: ZIO[Any, AwsError, List[ConfigRuleName]] =
      AwsError.unwrapOptionField("configRuleNames", configRuleNames)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.DescribeConfigRulesFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest
  ) extends zio.aws.config.model.DescribeConfigRulesRequest.ReadOnly {
    override val configRuleNames: Optional[List[ConfigRuleName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configRuleNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.ConfigRuleName(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val filters
        : Optional[zio.aws.config.model.DescribeConfigRulesFilters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          zio.aws.config.model.DescribeConfigRulesFilters.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest
  ): zio.aws.config.model.DescribeConfigRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
