package zio.aws.config.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.config.model.primitives.{
  AwsRegion,
  AccountId,
  StringWithCharLimit256,
  Date
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AggregateEvaluationResult(
    evaluationResultIdentifier: Optional[
      zio.aws.config.model.EvaluationResultIdentifier
    ] = Optional.Absent,
    complianceType: Optional[zio.aws.config.model.ComplianceType] =
      Optional.Absent,
    resultRecordedTime: Optional[Date] = Optional.Absent,
    configRuleInvokedTime: Optional[Date] = Optional.Absent,
    annotation: Optional[StringWithCharLimit256] = Optional.Absent,
    accountId: Optional[AccountId] = Optional.Absent,
    awsRegion: Optional[AwsRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateEvaluationResult = {
    import AggregateEvaluationResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateEvaluationResult
      .builder()
      .optionallyWith(
        evaluationResultIdentifier.map(value => value.buildAwsValue())
      )(_.evaluationResultIdentifier)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        resultRecordedTime.map(value => Date.unwrap(value): Instant)
      )(_.resultRecordedTime)
      .optionallyWith(
        configRuleInvokedTime.map(value => Date.unwrap(value): Instant)
      )(_.configRuleInvokedTime)
      .optionallyWith(
        annotation.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.annotation)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .build()
  }
  def asReadOnly: zio.aws.config.model.AggregateEvaluationResult.ReadOnly =
    zio.aws.config.model.AggregateEvaluationResult.wrap(buildAwsValue())
}
object AggregateEvaluationResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateEvaluationResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregateEvaluationResult =
      zio.aws.config.model.AggregateEvaluationResult(
        evaluationResultIdentifier.map(value => value.asEditable),
        complianceType.map(value => value),
        resultRecordedTime.map(value => value),
        configRuleInvokedTime.map(value => value),
        annotation.map(value => value),
        accountId.map(value => value),
        awsRegion.map(value => value)
      )
    def evaluationResultIdentifier
        : Optional[zio.aws.config.model.EvaluationResultIdentifier.ReadOnly]
    def complianceType: Optional[zio.aws.config.model.ComplianceType]
    def resultRecordedTime: Optional[Date]
    def configRuleInvokedTime: Optional[Date]
    def annotation: Optional[StringWithCharLimit256]
    def accountId: Optional[AccountId]
    def awsRegion: Optional[AwsRegion]
    def getEvaluationResultIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.EvaluationResultIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "evaluationResultIdentifier",
      evaluationResultIdentifier
    )
    def getComplianceType
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getResultRecordedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("resultRecordedTime", resultRecordedTime)
    def getConfigRuleInvokedTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("configRuleInvokedTime", configRuleInvokedTime)
    def getAnnotation: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("annotation", annotation)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateEvaluationResult
  ) extends zio.aws.config.model.AggregateEvaluationResult.ReadOnly {
    override val evaluationResultIdentifier
        : Optional[zio.aws.config.model.EvaluationResultIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evaluationResultIdentifier())
        .map(value =>
          zio.aws.config.model.EvaluationResultIdentifier.wrap(value)
        )
    override val complianceType: Optional[zio.aws.config.model.ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value => zio.aws.config.model.ComplianceType.wrap(value))
    override val resultRecordedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.resultRecordedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val configRuleInvokedTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.configRuleInvokedTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
    override val annotation: Optional[StringWithCharLimit256] =
      zio.aws.core.internal
        .optionalFromNullable(impl.annotation())
        .map(value =>
          zio.aws.config.model.primitives.StringWithCharLimit256(value)
        )
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val awsRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateEvaluationResult
  ): zio.aws.config.model.AggregateEvaluationResult.ReadOnly = new Wrapper(impl)
}
